"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadFleetExtension = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _constants = require("@kbn/cloud-security-posture-common/constants");
var _helpers = require("../../../common/utils/helpers");
var _use_kibana = require("../../common/hooks/use_kibana");
var _constants2 = require("../../../common/constants");
var _use_package_policy_list = require("../../common/api/use_package_policy_list");
var _utils = require("./utils");
var _use_is_subscription_status_valid = require("../../common/hooks/use_is_subscription_status_valid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSelectedOption = (options, policyTemplate = _constants.CSPM_POLICY_TEMPLATE) => {
  // Looks for the enabled deployment (aka input). By default, all inputs are disabled.
  // Initial state when all inputs are disabled is to choose the first available of the relevant policyTemplate
  // Default selected policy template is CSPM
  const selectedOption = options.find(i => i.enabled) || options.find(i => i.policy_template === policyTemplate) || options[0];
  (0, _helpers.assert)(selectedOption, 'Failed to determine selected option'); // We can't provide a default input without knowing the policy template
  (0, _helpers.assert)((0, _utils.isPostureInput)(selectedOption), 'Unknown option: ' + selectedOption.type);
  return selectedOption;
};
const usePolicyTemplateInitialName = ({
  isEditPage,
  isLoading,
  integration,
  newPolicy,
  packagePolicyList,
  updatePolicy,
  setCanFetchIntegration
}) => {
  (0, _react.useEffect)(() => {
    if (!integration || isEditPage || isLoading) return;
    const packagePolicyListByIntegration = packagePolicyList === null || packagePolicyList === void 0 ? void 0 : packagePolicyList.filter(policy => {
      var _policy$vars, _policy$vars$posture;
      return (policy === null || policy === void 0 ? void 0 : (_policy$vars = policy.vars) === null || _policy$vars === void 0 ? void 0 : (_policy$vars$posture = _policy$vars.posture) === null || _policy$vars$posture === void 0 ? void 0 : _policy$vars$posture.value) === integration;
    });
    const currentIntegrationName = (0, _utils.getMaxPackageName)(integration, packagePolicyListByIntegration);

    /*
     * If 'packagePolicyListByIntegration' is undefined it means policies were still not feteched - Array.isArray(undefined) = false
     * if policie were fetched its an array - the check will return true
     */
    const isPoliciesLoaded = Array.isArray(packagePolicyListByIntegration);
    updatePolicy({
      updatedPolicy: {
        ...newPolicy,
        name: currentIntegrationName
      },
      isExtensionLoaded: isPoliciesLoaded
    });
    setCanFetchIntegration(false);
    // since this useEffect should only run on initial mount updatePolicy and newPolicy shouldn't re-trigger it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [integration, isEditPage, packagePolicyList, isLoading]);
};
const useCloudFormationTemplate = ({
  packageInfo,
  newPolicy,
  updatePolicy,
  isLoading
}) => {
  var _newPolicy$vars;
  (0, _react.useEffect)(() => {
    var _newPolicy$inputs, _newPolicy$inputs$fin, _newPolicy$inputs$fin2, _newPolicy$inputs$fin3;
    if (isLoading || newPolicy.inputs.some(input => {
      var _input$config;
      return input.type === _constants2.CLOUDBEAT_VULN_MGMT_AWS && ((_input$config = input.config) === null || _input$config === void 0 ? void 0 : _input$config.cloud_formation_template_url);
    })) {
      return;
    }
    const templateUrl = (0, _utils.getVulnMgmtCloudFormationDefaultValue)(packageInfo);

    // If the template is not available, do not update the policy
    if (templateUrl === '') return;
    const checkCurrentTemplate = newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$inputs = newPolicy.inputs) === null || _newPolicy$inputs === void 0 ? void 0 : (_newPolicy$inputs$fin = _newPolicy$inputs.find(i => i.type === _constants2.CLOUDBEAT_VULN_MGMT_AWS)) === null || _newPolicy$inputs$fin === void 0 ? void 0 : (_newPolicy$inputs$fin2 = _newPolicy$inputs$fin.config) === null || _newPolicy$inputs$fin2 === void 0 ? void 0 : (_newPolicy$inputs$fin3 = _newPolicy$inputs$fin2.cloud_formation_template_url) === null || _newPolicy$inputs$fin3 === void 0 ? void 0 : _newPolicy$inputs$fin3.value;

    // If the template is already set, do not update the policy
    if (checkCurrentTemplate === templateUrl) return;
    updatePolicy === null || updatePolicy === void 0 ? void 0 : updatePolicy({
      updatedPolicy: {
        ...newPolicy,
        inputs: newPolicy.inputs.map(input => {
          if (input.type === _constants2.CLOUDBEAT_VULN_MGMT_AWS) {
            return {
              ...input,
              config: {
                cloud_formation_template_url: {
                  value: templateUrl
                }
              }
            };
          }
          return input;
        })
      }
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$vars = newPolicy.vars) === null || _newPolicy$vars === void 0 ? void 0 : _newPolicy$vars.cloud_formation_template_url, newPolicy, packageInfo]);
};
const getFormState = (policyTemplate, validationResults) => {
  if (policyTemplate === 'kspm' || policyTemplate === 'vuln_mgmt') {
    return true; // Default to valid for KSPM and Vulnerability Management
  }
  // This a workaround for a bug in Fleet where CSPM is not getting the VALID formState change from Fleet
  if (policyTemplate === 'cspm' && !(0, _utils.hasErrors)(validationResults)) {
    return true; // CSPM is valid if formState is INVALID but no required vars are invalid
  }
  return false; // Default to false for other cases
};
const DEFAULT_INPUT_TYPE = {
  kspm: _constants2.CLOUDBEAT_VANILLA,
  cspm: _constants2.CLOUDBEAT_AWS,
  vuln_mgmt: _constants2.CLOUDBEAT_VULN_MGMT_AWS
};
const useLoadFleetExtension = ({
  newPolicy,
  onChange,
  isEditPage,
  packageInfo,
  integrationToEnable,
  validationResults
}) => {
  const {
    cloud,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const integration = integrationToEnable && _constants2.SUPPORTED_POLICY_TEMPLATES.includes(integrationToEnable) ? integrationToEnable : undefined;
  const input = getSelectedOption(newPolicy.inputs, integration);
  const enabledPolicyInputCount = newPolicy.inputs.filter(i => i.enabled).length;
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [canFetchIntegration, setCanFetchIntegration] = (0, _react.useState)(true);
  const getIsSubscriptionValid = (0, _use_is_subscription_status_valid.useIsSubscriptionStatusValid)();
  const isSubscriptionValid = !!getIsSubscriptionValid.data;
  const isSubscriptionLoading = !!getIsSubscriptionValid.isLoading;
  const isValidFormState = getFormState(input.policy_template, validationResults);
  const setInitialEnabledInputRef = (0, _react.useRef)(false);
  const updatePolicy = (0, _react.useCallback)(({
    updatedPolicy,
    isExtensionLoaded,
    isValid
  }) => {
    const selectedInput = getSelectedOption(updatedPolicy.inputs, input.policy_template);

    // This is unique to the CSPM policy template, where we need to set the deployment and posture vars
    const newUpdatedPolicy = {
      ...updatedPolicy,
      vars: (0, _lodash.merge)({}, updatedPolicy.vars, {
        deployment: {
          value: (0, _utils.getDeploymentType)(selectedInput.type)
        },
        posture: {
          value: (0, _utils.getPostureType)(selectedInput.type)
        }
      })
    };
    onChange({
      isValid,
      updatedPolicy: newUpdatedPolicy,
      isExtensionLoaded: isExtensionLoaded !== undefined ? isExtensionLoaded : !isLoading
    });
  }, [input.policy_template, onChange, isLoading]);
  const setEnabledPolicyInput = (0, _react.useCallback)(inputType => {
    const inputVars = (0, _utils.getPostureInputHiddenVars)(inputType);
    const policy = (0, _utils.getPosturePolicy)(newPolicy, inputType, inputVars);
    updatePolicy({
      updatedPolicy: policy
    });
  }, [newPolicy, updatePolicy]);
  const {
    data: packagePolicyList,
    refetch
  } = (0, _use_package_policy_list.usePackagePolicyList)(packageInfo.name, {
    enabled: canFetchIntegration
  });
  if (!isEditPage && !isLoading && !isSubscriptionLoading && (enabledPolicyInputCount === 0 || enabledPolicyInputCount > 1)) {
    setInitialEnabledInputRef.current = true;
    setEnabledPolicyInput(DEFAULT_INPUT_TYPE[input.policy_template]);
    refetch();
  }
  useCloudFormationTemplate({
    packageInfo,
    updatePolicy,
    newPolicy,
    isLoading
  });
  usePolicyTemplateInitialName({
    packagePolicyList: packagePolicyList === null || packagePolicyList === void 0 ? void 0 : packagePolicyList.items,
    isEditPage,
    isLoading,
    integration: integration,
    newPolicy,
    updatePolicy,
    setCanFetchIntegration
  });
  if (!isSubscriptionLoading && isLoading && isValidFormState !== undefined) {
    setIsLoading(false);
  }
  if (isEditPage && isLoading && isSubscriptionValid) {
    setIsLoading(false);
  }
  return {
    cloud,
    isLoading,
    isValid: !!isValidFormState,
    isSubscriptionValid,
    input,
    setEnabledPolicyInput,
    updatePolicy,
    uiSettings
  };
};
exports.useLoadFleetExtension = useLoadFleetExtension;