"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelVersion8 = void 0;
var _schemas = require("../schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const backfillFn = ({
  attributes
}) => {
  var _attributes$observabl, _attributes$observabl2;
  return {
    attributes: {
      total_observables: (_attributes$observabl = (_attributes$observabl2 = attributes.observables) === null || _attributes$observabl2 === void 0 ? void 0 : _attributes$observabl2.length) !== null && _attributes$observabl !== void 0 ? _attributes$observabl : 0
    }
  };
};

/**
 * Adds the total_events field to the cases SO.
 */
const modelVersion8 = exports.modelVersion8 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      total_observables: {
        type: 'integer'
      }
    }
  }, {
    type: 'data_backfill',
    backfillFn
  }],
  schemas: {
    forwardCompatibility: _schemas.casesSchemaV8.extends({}, {
      unknowns: 'ignore'
    })
  }
};