"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_CASE = exports.VERSION_CONFLICT_WARNING = exports.UPDATED_ON = exports.UNKNOWN = exports.TO = exports.TITLE_REQUIRED = exports.TAGS_HELP = exports.TAGS_EMPTY_ERROR = exports.TAGS = exports.SYNC_ALERTS_SWITCH_LABEL_ON = exports.SYNC_ALERTS_SWITCH_LABEL_OFF = exports.SYNC_ALERTS_HELP = exports.SYNC_ALERTS = exports.SOLUTION_REQUIRED = exports.SOLUTION = exports.SET_SEVERITY_TO = exports.SELECT_CASE_TITLE = exports.SAVE = exports.SAFE_INTEGER_NUMBER_ERROR = exports.REQUIRED_FIELD = exports.REPORTER = exports.REOPEN_CASE = exports.REMOVE_CATEGORY = exports.READ_ACTIONS_PERMISSIONS_ERROR_MSG = exports.PARTICIPANTS = exports.PAGE_TITLE = exports.OPTIONAL = exports.OPEN_CASES = exports.OPEN_CASE = exports.NO_TAGS_AVAILABLE = exports.NO_TAGS = exports.NO_REPORTERS_AVAILABLE = exports.NO_CONNECTOR = exports.NO_CATEGORIES_AVAILABLE = exports.NO_CATEGORIES = exports.NAME = exports.MAX_TAGS_ERROR = exports.MAX_LENGTH_ERROR = exports.MARK_CASE_IN_PROGRESS = exports.MARKED_CASE_AS = exports.LINK_APPROPRIATE_LICENSE = exports.IN_PROGRESS_CASES = exports.EXTRACT_OBSERVABLES_SWITCH_LABEL_ON = exports.EXTRACT_OBSERVABLES_SWITCH_LABEL_OFF = exports.EXTRACT_OBSERVABLES_LABEL = exports.EXTRACT_OBSERVABLES_HELP = exports.EXPERIMENTAL_LABEL = exports.EXPERIMENTAL_DESC = exports.EVENTS = exports.EMPTY_COMMENTS_NOT_ALLOWED = exports.EDIT = exports.DESCRIPTION_REQUIRED = exports.DESCRIPTION = exports.DELETE_CASE = exports.DELETED_CASES = exports.CREATE_CASE_TITLE = exports.CREATE_CASE = exports.CREATED_ON = exports.COPY_ID_ACTION_SUCCESS = exports.COPY_ID_ACTION_LABEL = exports.CONNECTORS = exports.CONFIGURE_CASES_BUTTON = exports.COMMENTS = exports.CLOSE_CASE = exports.CLOSED_ON = exports.CLOSED_CASES = exports.CATEGORY = exports.CATEGORIES = exports.CASE_SUCCESS_TOAST = exports.CASE_NAME = exports.CASE_ALERT_SUCCESS_TOAST = exports.CASE_ALERT_SUCCESS_SYNC_TEXT = exports.CASE_ALERT_SUCCESS_SYNC_AND_EXTRACT_TEXT = exports.CASE_ALERT_SUCCESS_OBSERVABLES_TEXT = exports.CANCEL = exports.BACK_TO_ALL = exports.ARIA_KEYPAD_LEGEND = exports.APP_TITLE = exports.APP_DESC = exports.ALERT_ADDED_TO_CASE = exports.ALERTS = exports.ALERT = exports.ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX = exports.ADD_TAG_CUSTOM_OPTION_LABEL = exports.ADD_COMMENT_HELP_TEXT = exports.ADD_COMMENT = exports.ADD_CATEGORY_CUSTOM_OPTION_LABEL_COMBO_BOX = exports.ADD_CATEGORY_CUSTOM_OPTION_LABEL = exports.ADD_CATEGORY = exports.ACTIONS_BUTTON_ARIA_LABEL = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BACK_TO_ALL = exports.BACK_TO_ALL = _i18n.i18n.translate('xpack.cases.caseView.backLabel', {
  defaultMessage: 'Back to cases'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.cases.caseView.cancel', {
  defaultMessage: 'Cancel'
});
const DELETE_CASE = (quantity = 1) => _i18n.i18n.translate('xpack.cases.confirmDeleteCase.deleteCase', {
  values: {
    quantity
  },
  defaultMessage: `Delete {quantity, plural, =1 {case} other {{quantity} cases}}`
});
exports.DELETE_CASE = DELETE_CASE;
const COPY_ID_ACTION_LABEL = exports.COPY_ID_ACTION_LABEL = _i18n.i18n.translate('xpack.cases.caseView.copyID', {
  defaultMessage: 'Copy case ID'
});
const COPY_ID_ACTION_SUCCESS = exports.COPY_ID_ACTION_SUCCESS = _i18n.i18n.translate('xpack.cases.caseView.copyIDSuccess', {
  defaultMessage: 'Copied case ID to clipboard'
});
const NAME = exports.NAME = _i18n.i18n.translate('xpack.cases.caseView.name', {
  defaultMessage: 'Name'
});
const CREATED_ON = exports.CREATED_ON = _i18n.i18n.translate('xpack.cases.caseView.createdOn', {
  defaultMessage: 'Created on'
});
const UPDATED_ON = exports.UPDATED_ON = _i18n.i18n.translate('xpack.cases.caseView.updatedOn', {
  defaultMessage: 'Updated on'
});
const CLOSED_ON = exports.CLOSED_ON = _i18n.i18n.translate('xpack.cases.caseView.closedOn', {
  defaultMessage: 'Closed on'
});
const REPORTER = exports.REPORTER = _i18n.i18n.translate('xpack.cases.caseView.reporterLabel', {
  defaultMessage: 'Reporter'
});
const PARTICIPANTS = exports.PARTICIPANTS = _i18n.i18n.translate('xpack.cases.caseView.particpantsLabel', {
  defaultMessage: 'Participants'
});
const CREATE_CASE_TITLE = exports.CREATE_CASE_TITLE = _i18n.i18n.translate('xpack.cases.caseView.create', {
  defaultMessage: 'Create case'
});
const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.description', {
  defaultMessage: 'Description'
});
const DESCRIPTION_REQUIRED = exports.DESCRIPTION_REQUIRED = _i18n.i18n.translate('xpack.cases.createCase.descriptionFieldRequiredError', {
  defaultMessage: 'A description is required.'
});
const SOLUTION_REQUIRED = exports.SOLUTION_REQUIRED = _i18n.i18n.translate('xpack.cases.createCase.solutionFieldRequiredError', {
  defaultMessage: 'A solution is required'
});
const ARIA_KEYPAD_LEGEND = exports.ARIA_KEYPAD_LEGEND = _i18n.i18n.translate('xpack.cases.createCase.ariaKeypadSolutionSelection', {
  defaultMessage: 'Single solution select'
});
const EMPTY_COMMENTS_NOT_ALLOWED = exports.EMPTY_COMMENTS_NOT_ALLOWED = _i18n.i18n.translate('xpack.cases.caseView.commentFieldRequiredError', {
  defaultMessage: 'Empty comments are not allowed.'
});
const REQUIRED_FIELD = exports.REQUIRED_FIELD = _i18n.i18n.translate('xpack.cases.caseView.fieldRequiredError', {
  defaultMessage: 'Required field'
});
const EDIT = exports.EDIT = _i18n.i18n.translate('xpack.cases.caseView.edit', {
  defaultMessage: 'Edit'
});
const OPTIONAL = exports.OPTIONAL = _i18n.i18n.translate('xpack.cases.caseView.optional', {
  defaultMessage: 'Optional'
});
const PAGE_TITLE = exports.PAGE_TITLE = _i18n.i18n.translate('xpack.cases.pageTitle', {
  defaultMessage: 'Cases'
});
const CREATE_CASE = exports.CREATE_CASE = _i18n.i18n.translate('xpack.cases.caseView.createCase', {
  defaultMessage: 'Create case'
});
const CLOSE_CASE = exports.CLOSE_CASE = _i18n.i18n.translate('xpack.cases.caseView.closeCase', {
  defaultMessage: 'Close case'
});
const MARK_CASE_IN_PROGRESS = exports.MARK_CASE_IN_PROGRESS = _i18n.i18n.translate('xpack.cases.caseView.markInProgress', {
  defaultMessage: 'Mark in progress'
});
const REOPEN_CASE = exports.REOPEN_CASE = _i18n.i18n.translate('xpack.cases.caseView.reopenCase', {
  defaultMessage: 'Reopen case'
});
const OPEN_CASE = exports.OPEN_CASE = _i18n.i18n.translate('xpack.cases.caseView.openCase', {
  defaultMessage: 'Open case'
});
const CASE_NAME = exports.CASE_NAME = _i18n.i18n.translate('xpack.cases.caseView.caseName', {
  defaultMessage: 'Case name'
});
const TO = exports.TO = _i18n.i18n.translate('xpack.cases.caseView.to', {
  defaultMessage: 'to'
});
const TAGS = exports.TAGS = _i18n.i18n.translate('xpack.cases.caseView.tags', {
  defaultMessage: 'Tags'
});
const CATEGORY = exports.CATEGORY = _i18n.i18n.translate('xpack.cases.caseView.category', {
  defaultMessage: 'Category'
});
const CATEGORIES = exports.CATEGORIES = _i18n.i18n.translate('xpack.cases.caseView.categories', {
  defaultMessage: 'Categories'
});
const SOLUTION = exports.SOLUTION = _i18n.i18n.translate('xpack.cases.caseView.solution', {
  defaultMessage: 'Solution'
});
const ACTIONS = exports.ACTIONS = _i18n.i18n.translate('xpack.cases.allCases.actions', {
  defaultMessage: 'Actions'
});
const ACTIONS_BUTTON_ARIA_LABEL = title => _i18n.i18n.translate('xpack.cases.allCases.actions.button.ariaLabel', {
  defaultMessage: 'Actions for "{title}" column',
  values: {
    title
  }
});
exports.ACTIONS_BUTTON_ARIA_LABEL = ACTIONS_BUTTON_ARIA_LABEL;
const NO_TAGS_AVAILABLE = exports.NO_TAGS_AVAILABLE = _i18n.i18n.translate('xpack.cases.allCases.noTagsAvailable', {
  defaultMessage: 'No tags available'
});
const NO_REPORTERS_AVAILABLE = exports.NO_REPORTERS_AVAILABLE = _i18n.i18n.translate('xpack.cases.caseView.noReportersAvailable', {
  defaultMessage: 'No reporters available.'
});
const NO_CATEGORIES_AVAILABLE = exports.NO_CATEGORIES_AVAILABLE = _i18n.i18n.translate('xpack.cases.allCases.noCategoriesAvailable', {
  defaultMessage: 'No categories available'
});
const COMMENTS = exports.COMMENTS = _i18n.i18n.translate('xpack.cases.allCases.comments', {
  defaultMessage: 'Comments'
});
const TAGS_HELP = exports.TAGS_HELP = _i18n.i18n.translate('xpack.cases.createCase.fieldTagsHelpText', {
  defaultMessage: 'Separate tags with a line break.'
});
const TAGS_EMPTY_ERROR = exports.TAGS_EMPTY_ERROR = _i18n.i18n.translate('xpack.cases.createCase.fieldTagsEmptyError', {
  defaultMessage: 'A tag must contain at least one non-space character.'
});
const NO_TAGS = exports.NO_TAGS = _i18n.i18n.translate('xpack.cases.caseView.noTags', {
  defaultMessage: 'No tags are added'
});
const NO_CATEGORIES = exports.NO_CATEGORIES = _i18n.i18n.translate('xpack.cases.caseView.noCategories', {
  defaultMessage: 'No category is added'
});
const TITLE_REQUIRED = exports.TITLE_REQUIRED = _i18n.i18n.translate('xpack.cases.createCase.titleFieldRequiredError', {
  defaultMessage: 'A name is required.'
});
const CONFIGURE_CASES_BUTTON = exports.CONFIGURE_CASES_BUTTON = _i18n.i18n.translate('xpack.cases.configureCasesButton', {
  defaultMessage: 'Settings'
});
const ADD_COMMENT = exports.ADD_COMMENT = _i18n.i18n.translate('xpack.cases.caseView.comment.addComment', {
  defaultMessage: 'Add comment'
});
const ADD_COMMENT_HELP_TEXT = exports.ADD_COMMENT_HELP_TEXT = _i18n.i18n.translate('xpack.cases.caseView.comment.addCommentHelpText', {
  defaultMessage: 'Add a new comment...'
});
const SAVE = exports.SAVE = _i18n.i18n.translate('xpack.cases.caseView.description.save', {
  defaultMessage: 'Save'
});
const CONNECTORS = exports.CONNECTORS = _i18n.i18n.translate('xpack.cases.caseView.connectors', {
  defaultMessage: 'External incident management system'
});
const NO_CONNECTOR = exports.NO_CONNECTOR = _i18n.i18n.translate('xpack.cases.common.noConnector', {
  defaultMessage: 'No connector selected'
});
const UNKNOWN = exports.UNKNOWN = _i18n.i18n.translate('xpack.cases.caseView.unknown', {
  defaultMessage: 'Unknown'
});
const MARKED_CASE_AS = exports.MARKED_CASE_AS = _i18n.i18n.translate('xpack.cases.caseView.markedCaseAs', {
  defaultMessage: 'marked case as'
});
const ADD_CATEGORY = exports.ADD_CATEGORY = _i18n.i18n.translate('xpack.cases.caseView.addCategory', {
  defaultMessage: 'added the category'
});
const REMOVE_CATEGORY = exports.REMOVE_CATEGORY = _i18n.i18n.translate('xpack.cases.caseView.userAction.removeCategory', {
  defaultMessage: 'removed the category'
});
const SET_SEVERITY_TO = exports.SET_SEVERITY_TO = _i18n.i18n.translate('xpack.cases.caseView.setSeverityTo', {
  defaultMessage: 'set severity to'
});
const OPEN_CASES = exports.OPEN_CASES = _i18n.i18n.translate('xpack.cases.caseTable.openCases', {
  defaultMessage: 'Open cases'
});
const CLOSED_CASES = exports.CLOSED_CASES = _i18n.i18n.translate('xpack.cases.caseTable.closedCases', {
  defaultMessage: 'Closed cases'
});
const IN_PROGRESS_CASES = exports.IN_PROGRESS_CASES = _i18n.i18n.translate('xpack.cases.caseTable.inProgressCases', {
  defaultMessage: 'In progress cases'
});
const SYNC_ALERTS_SWITCH_LABEL_ON = exports.SYNC_ALERTS_SWITCH_LABEL_ON = _i18n.i18n.translate('xpack.cases.settings.syncAlertsSwitchLabelOn', {
  defaultMessage: 'On'
});
const SYNC_ALERTS_SWITCH_LABEL_OFF = exports.SYNC_ALERTS_SWITCH_LABEL_OFF = _i18n.i18n.translate('xpack.cases.settings.syncAlertsSwitchLabelOff', {
  defaultMessage: 'Off'
});
const SYNC_ALERTS = exports.SYNC_ALERTS = _i18n.i18n.translate('xpack.cases.settings.syncAlerts', {
  defaultMessage: 'Sync alerts'
});
const SYNC_ALERTS_HELP = exports.SYNC_ALERTS_HELP = _i18n.i18n.translate('xpack.cases.components.create.syncAlertHelpText', {
  defaultMessage: 'Enabling this option will sync the alert statuses with the case status.'
});
const EXTRACT_OBSERVABLES_SWITCH_LABEL_ON = exports.EXTRACT_OBSERVABLES_SWITCH_LABEL_ON = _i18n.i18n.translate('xpack.cases.settings.extractObservablesSwitchLabelOn', {
  defaultMessage: 'On'
});
const EXTRACT_OBSERVABLES_SWITCH_LABEL_OFF = exports.EXTRACT_OBSERVABLES_SWITCH_LABEL_OFF = _i18n.i18n.translate('xpack.cases.settings.extractObservablesSwitchLabelOff', {
  defaultMessage: 'Off'
});
const EXTRACT_OBSERVABLES_LABEL = exports.EXTRACT_OBSERVABLES_LABEL = _i18n.i18n.translate('xpack.cases.settings.extractObservablesLabel', {
  defaultMessage: 'Extract observables'
});
const EXTRACT_OBSERVABLES_HELP = exports.EXTRACT_OBSERVABLES_HELP = _i18n.i18n.translate('xpack.cases.components.create.extractObservablesHelpText', {
  defaultMessage: 'Enabling this option will extract observables from the alert automatically.'
});
const ALERT = exports.ALERT = _i18n.i18n.translate('xpack.cases.common.alertLabel', {
  defaultMessage: 'Alert'
});
const ALERTS = exports.ALERTS = _i18n.i18n.translate('xpack.cases.common.alertsLabel', {
  defaultMessage: 'Alerts'
});
const ALERT_ADDED_TO_CASE = exports.ALERT_ADDED_TO_CASE = _i18n.i18n.translate('xpack.cases.common.alertAddedToCase', {
  defaultMessage: 'added to case'
});
const EVENTS = exports.EVENTS = _i18n.i18n.translate('xpack.cases.common.eventsLabel', {
  defaultMessage: 'Events'
});
const SELECT_CASE_TITLE = exports.SELECT_CASE_TITLE = _i18n.i18n.translate('xpack.cases.common.allCases.caseModal.title', {
  defaultMessage: 'Select case'
});
const MAX_LENGTH_ERROR = (field, length) => _i18n.i18n.translate('xpack.cases.createCase.maxLengthError', {
  values: {
    field,
    length
  },
  defaultMessage: 'The length of the {field} is too long. The maximum length is {length} characters.'
});
exports.MAX_LENGTH_ERROR = MAX_LENGTH_ERROR;
const SAFE_INTEGER_NUMBER_ERROR = field => _i18n.i18n.translate('xpack.cases.customFields.safeIntegerNumberError', {
  values: {
    field
  },
  defaultMessage: `The value of the {field} should be an integer between -(2^53 - 1) and 2^53 - 1, inclusive.`
});
exports.SAFE_INTEGER_NUMBER_ERROR = SAFE_INTEGER_NUMBER_ERROR;
const MAX_TAGS_ERROR = length => _i18n.i18n.translate('xpack.cases.createCase.maxTagsError', {
  values: {
    length
  },
  defaultMessage: 'Too many tags. The maximum number of allowed tags is {length}'
});
exports.MAX_TAGS_ERROR = MAX_TAGS_ERROR;
const LINK_APPROPRIATE_LICENSE = exports.LINK_APPROPRIATE_LICENSE = _i18n.i18n.translate('xpack.cases.common.appropriateLicense', {
  defaultMessage: 'appropriate license'
});
const CASE_SUCCESS_TOAST = title => _i18n.i18n.translate('xpack.cases.actions.caseSuccessToast', {
  values: {
    title
  },
  defaultMessage: 'Case {title} updated'
});
exports.CASE_SUCCESS_TOAST = CASE_SUCCESS_TOAST;
const CASE_ALERT_SUCCESS_TOAST = (title, quantity = 1) => _i18n.i18n.translate('xpack.cases.actions.caseAlertSuccessToast', {
  values: {
    quantity,
    title
  },
  defaultMessage: '{quantity, plural, =1 {An alert was} other {Alerts were}} added to "{title}"'
});
exports.CASE_ALERT_SUCCESS_TOAST = CASE_ALERT_SUCCESS_TOAST;
const CASE_ALERT_SUCCESS_SYNC_TEXT = exports.CASE_ALERT_SUCCESS_SYNC_TEXT = _i18n.i18n.translate('xpack.cases.actions.caseAlertSuccessSyncText', {
  defaultMessage: "Alert statuses were synced with the case's status."
});
const CASE_ALERT_SUCCESS_OBSERVABLES_TEXT = exports.CASE_ALERT_SUCCESS_OBSERVABLES_TEXT = _i18n.i18n.translate('xpack.cases.actions.caseAlertSuccessObservablesText', {
  defaultMessage: 'Observables were extracted and added to the case.'
});
const CASE_ALERT_SUCCESS_SYNC_AND_EXTRACT_TEXT = exports.CASE_ALERT_SUCCESS_SYNC_AND_EXTRACT_TEXT = _i18n.i18n.translate('xpack.cases.actions.caseAlertSuccessSyncAndExtractText', {
  defaultMessage: "Alert statuses were synced with the case's status and observables were extracted and added to the case."
});
const VIEW_CASE = exports.VIEW_CASE = _i18n.i18n.translate('xpack.cases.actions.viewCase', {
  defaultMessage: 'View case'
});
const APP_TITLE = exports.APP_TITLE = _i18n.i18n.translate('xpack.cases.common.appTitle', {
  defaultMessage: 'Cases'
});
const APP_DESC = exports.APP_DESC = _i18n.i18n.translate('xpack.cases.common.appDescription', {
  defaultMessage: 'Open and track issues, push information to third party systems.'
});
const READ_ACTIONS_PERMISSIONS_ERROR_MSG = exports.READ_ACTIONS_PERMISSIONS_ERROR_MSG = _i18n.i18n.translate('xpack.cases.configure.readPermissionsErrorDescription', {
  defaultMessage: 'You do not have permission to view connectors. If you would like to view connectors, contact your Kibana administrator.'
});
const DELETED_CASES = totalCases => _i18n.i18n.translate('xpack.cases.containers.deletedCases', {
  values: {
    totalCases
  },
  defaultMessage: 'Deleted {totalCases, plural, =1 {case} other {{totalCases} cases}}'
});
exports.DELETED_CASES = DELETED_CASES;
const ADD_TAG_CUSTOM_OPTION_LABEL = searchValue => _i18n.i18n.translate('xpack.cases.configure.addTagCustomOptionLabel', {
  defaultMessage: 'Add {searchValue} as a tag',
  values: {
    searchValue
  }
});
exports.ADD_TAG_CUSTOM_OPTION_LABEL = ADD_TAG_CUSTOM_OPTION_LABEL;
const ADD_CATEGORY_CUSTOM_OPTION_LABEL = searchValue => _i18n.i18n.translate('xpack.cases.configure.addCategoryCustomOptionLabel', {
  defaultMessage: 'Add {searchValue} as a category',
  values: {
    searchValue
  }
});
exports.ADD_CATEGORY_CUSTOM_OPTION_LABEL = ADD_CATEGORY_CUSTOM_OPTION_LABEL;
const VERSION_CONFLICT_WARNING = markdownId => _i18n.i18n.translate('xpack.cases.configure.commentVersionConflictWarning', {
  defaultMessage: 'This {markdownId} has been updated by another user. Saving your {markdownId} will overwrite their update.',
  values: {
    markdownId
  }
});

/**
 * EUI checkbox replace {searchValue} with the current
 * search value. We need to put the template variable
 * searchValue in the string but not replace it
 * with i18n.
 */
exports.VERSION_CONFLICT_WARNING = VERSION_CONFLICT_WARNING;
const ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX = exports.ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX = ADD_TAG_CUSTOM_OPTION_LABEL('{searchValue}');
const ADD_CATEGORY_CUSTOM_OPTION_LABEL_COMBO_BOX = exports.ADD_CATEGORY_CUSTOM_OPTION_LABEL_COMBO_BOX = ADD_CATEGORY_CUSTOM_OPTION_LABEL('{searchValue}');
const EXPERIMENTAL_LABEL = exports.EXPERIMENTAL_LABEL = _i18n.i18n.translate('xpack.cases.badge.experimentalLabel', {
  defaultMessage: 'Technical preview'
});
const EXPERIMENTAL_DESC = exports.EXPERIMENTAL_DESC = _i18n.i18n.translate('xpack.cases.badge.experimentalDesc', {
  defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
});