"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidebarHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _reactRedux = require("react-redux");
var _elements = require("../../state/actions/elements");
var _workpad = require("../../state/selectors/workpad");
var _functional = require("../../lib/aeroelastic/functional");
var _element_handler_creators = require("../../lib/element_handler_creators");
var _integration_utils = require("../workpad_page/integration_utils");
var _sidebar_header = require("./sidebar_header.component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/sidebar_header/sidebar_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error unconverted component
// @ts-expect-error unconverted lib
// @ts-expect-error unconverted component
const getSelectedNodes = (state, pageId) => {
  const nodes = (0, _workpad.getNodes)(state, pageId);
  const selectedToplevelNodes = (0, _workpad.getSelectedToplevelNodes)(state);
  const selectedPrimaryShapeObjects = selectedToplevelNodes.map(id => nodes.find(s => s.id === id)).filter(shape => shape);
  const selectedPersistentPrimaryNodes = (0, _functional.flatten)(selectedPrimaryShapeObjects.map(shape => nodes.find(n => n.id === (shape === null || shape === void 0 ? void 0 : shape.id)) // is it a leaf or a persisted group?
  ? [shape === null || shape === void 0 ? void 0 : shape.id] : nodes.filter(s => {
    var _s$position;
    return ((_s$position = s.position) === null || _s$position === void 0 ? void 0 : _s$position.parent) === (shape === null || shape === void 0 ? void 0 : shape.id);
  }).map(s => s.id)));
  const selectedNodeIds = (0, _functional.flatten)(selectedPersistentPrimaryNodes.map((0, _integration_utils.crawlTree)(nodes)));
  return selectedNodeIds.map(id => nodes.find(s => s.id === id));
};
const createHandlers = function (handlers, context) {
  return Object.keys(handlers).reduce((acc, val) => {
    acc[val] = handlers[val](context);
    return acc;
  }, {});
};
const SidebarHeader = props => {
  const pageId = (0, _reactRedux.useSelector)(state => (0, _workpad.getSelectedPage)(state));
  const selectedNodes = (0, _reactRedux.useSelector)(state => getSelectedNodes(state, pageId), _reactFastCompare.default);
  const dispatch = (0, _reactRedux.useDispatch)();
  const elementLayerDispatch = (selectedPageId, elementId, movement) => {
    dispatch((0, _elements.elementLayer)({
      pageId: selectedPageId,
      elementId,
      movement
    }));
  };
  const handlersContext = {
    ...props,
    pageId,
    selectedNodes,
    elementLayer: elementLayerDispatch
  };
  const layerHandlers = createHandlers(_element_handler_creators.layerHandlerCreators, handlersContext);
  return /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, (0, _extends2.default)({}, props, layerHandlers, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 10
    }
  }));
};
exports.SidebarHeader = SidebarHeader;