"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _template_from_react_component = require("../../../public/lib/template_from_react_component");
var _i18n = require("../../../i18n");
var _with_debounce_arg = require("../../../public/components/with_debounce_arg");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/uis/arguments/editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  Editor: strings
} = _i18n.ArgumentStrings;
const EditorArg = ({
  argValue,
  typeInstance,
  onValueChange,
  renderError
}) => {
  var _typeInstance$options;
  const [value, setValue] = (0, _react.useState)(argValue);
  const prevValue = (0, _usePrevious.default)(value);
  const onChange = (0, _react.useCallback)(text => setValue(text), [setValue]);
  (0, _react.useEffect)(() => {
    onValueChange(value);
  }, [onValueChange, value]);
  (0, _react.useEffect)(() => {
    // update editor content, if it has been changed from within the expression.
    if (prevValue === value && argValue !== value) {
      setValue(argValue);
    }
  }, [argValue, setValue, prevValue, value]);
  if (typeof argValue !== 'string') {
    renderError();
    return null;
  }
  const {
    language
  } = (_typeInstance$options = typeInstance === null || typeInstance === void 0 ? void 0 : typeInstance.options) !== null && _typeInstance$options !== void 0 ? _typeInstance$options : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    "data-test-subj": "canvasCodeEditorField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditorField, {
    languageId: language !== null && language !== void 0 ? language : '',
    value: value,
    onChange: onChange,
    options: {
      fontSize: 14,
      scrollBeyondLastLine: false,
      quickSuggestions: true,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent',
      lineNumbers: 'off',
      glyphMargin: false,
      folding: false
    },
    height: "350px",
    editorDidMount: editor => {
      const model = editor.getModel();
      model === null || model === void 0 ? void 0 : model.updateOptions({
        tabSize: 2
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
};
const editor = () => ({
  name: 'editor',
  displayName: strings.getDisplayName(),
  help: strings.getHelp(),
  template: (0, _template_from_react_component.templateFromReactComponent)((0, _with_debounce_arg.withDebounceArg)(EditorArg, 250))
});
exports.editor = editor;