"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveCustomLink = saveCustomLink;
var _i18n = require("@kbn/i18n");
var _create_call_apm_api = require("../../../../../services/rest/create_call_apm_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function saveCustomLink({
  id,
  label,
  url,
  filters,
  toasts
}) {
  try {
    const customLink = {
      label,
      url,
      filters: filters.filter(({
        key,
        value
      }) => key && value)
    };
    if (id) {
      await (0, _create_call_apm_api.callApmApi)('PUT /internal/apm/settings/custom_links/{id}', {
        signal: null,
        params: {
          path: {
            id
          },
          body: customLink
        }
      });
    } else {
      await (0, _create_call_apm_api.callApmApi)('POST /internal/apm/settings/custom_links', {
        signal: null,
        params: {
          body: customLink
        }
      });
    }
    toasts.addSuccess({
      iconType: 'check',
      title: _i18n.i18n.translate('xpack.apm.settings.customLink.create.successed', {
        defaultMessage: 'Link saved!'
      })
    });
  } catch (error) {
    toasts.addDanger({
      title: _i18n.i18n.translate('xpack.apm.settings.customLink.create.failed', {
        defaultMessage: 'Link could not be saved!'
      }),
      text: _i18n.i18n.translate('xpack.apm.settings.customLink.create.failed.message', {
        defaultMessage: 'Something went wrong when saving the link. Error: "{errorMessage}"',
        values: {
          errorMessage: error.message
        }
      })
    });
  }
}