"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkPreview = LinkPreview;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _create_call_apm_api = require("../../../../../services/rest/create_call_apm_api");
var _helper = require("./helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/custom_link/create_edit_custom_link_flyout/link_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchTransaction = (0, _lodash.debounce)(async (filters, callback) => {
  const transaction = await (0, _create_call_apm_api.callApmApi)('GET /internal/apm/settings/custom_links/transaction', {
    signal: null,
    params: {
      query: (0, _helper.convertFiltersToQuery)(filters)
    }
  });
  callback(transaction);
}, 1000);
const getTextColor = value => value ? 'default' : 'subdued';
function LinkPreview({
  label,
  url,
  filters
}) {
  const [transaction, setTransaction] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    /*
      React throwns "Can't perform a React state update on an unmounted component"
      It happens when the Custom Link flyout is closed before the return of the api request.
      To avoid such case, sets the isUnmounted to true when component unmount and check its value before update the transaction.
    */
    let isUnmounted = false;
    fetchTransaction(filters, _transaction => {
      if (!isUnmounted) {
        setTransaction(_transaction);
      }
    });
    return () => {
      isUnmounted = true;
    };
  }, [filters]);
  const {
    formattedUrl,
    error
  } = (0, _helper.replaceTemplateVariables)(url, transaction);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.previewSectionTitle', {
    defaultMessage: 'Preview'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: getTextColor(label),
    className: "eui-textBreakWord",
    "data-test-subj": "preview-label",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, label ? label : _i18n.i18n.translate('xpack.apm.settings.customLink.default.label', {
    defaultMessage: 'Elastic.co'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: getTextColor(url),
    className: "eui-textBreakWord",
    "data-test-subj": "preview-url",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, url ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: formattedUrl,
    target: "_blank",
    "data-test-subj": "preview-link",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }, formattedUrl) : _i18n.i18n.translate('xpack.apm.settings.customLink.default.url', {
    defaultMessage: 'https://www.elastic.co'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.linkPreview.descrition', {
    defaultMessage: 'Test your link with values from an example transaction document based on the filters above.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, error && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: error,
    position: "top",
    type: "warning",
    color: "warning",
    iconProps: {
      'data-test-subj': 'preview-warning'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  })))));
}