"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectServices = SelectServices;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _lodash = require("lodash");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _kuery_bar = require("../../../shared/kuery_bar");
var _service_list_preview = require("./service_list_preview");
var _helpers = require("../../../../context/url_params_context/helpers");
var _service_groups = require("../../../../../common/service_groups");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_group_save/select_services.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CentralizedContainer = _styled.default.div`
  display: flex;
  height: 100%;
  justify-content: center;
  align-items: center;
`;
const MAX_CONTAINER_HEIGHT = 600;
const MODAL_HEADER_HEIGHT = 180;
const MODAL_FOOTER_HEIGHT = 80;
const Container = _styled.default.div`
  height: ${MAX_CONTAINER_HEIGHT}px;
`;
function SelectServices({
  serviceGroup,
  isEdit,
  onCloseModal,
  onSaveClick,
  onEditGroupDetailsClick,
  isLoading,
  titleId
}) {
  const [kuery, setKuery] = (0, _react2.useState)((serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.kuery) || '');
  const [stagedKuery, setStagedKuery] = (0, _react2.useState)((serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.kuery) || '');
  const [kueryValidationMessage, setKueryValidationMessage] = (0, _react2.useState)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _react2.useEffect)(() => {
    if (isEdit) {
      setKuery(serviceGroup.kuery);
      setStagedKuery(serviceGroup.kuery);
    }
  }, [isEdit, serviceGroup.kuery]);
  const {
    start,
    end
  } = (0, _react2.useMemo)(() => (0, _helpers.getDateRange)({
    rangeFrom: 'now-24h',
    rangeTo: 'now'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [kuery]);
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end && !(0, _lodash.isEmpty)(kuery)) {
      return callApmApi('GET /internal/apm/service-group/services', {
        params: {
          query: {
            kuery,
            start,
            end
          }
        }
      });
    }
  }, [kuery, start, end], {
    preservePreviousData: true
  });
  const isServiceListPreviewLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const handleOnSubmit = () => {
    if (!stagedKuery) {
      return;
    }
    const {
      message
    } = (0, _service_groups.validateServiceGroupKuery)(stagedKuery);
    setKueryValidationMessage(message);
    if (!message) {
      setKuery(stagedKuery);
    }
  };
  return /*#__PURE__*/_react2.default.createElement(Container, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeaderTitle, {
    id: titleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.title', {
    defaultMessage: 'Select services'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.subtitle', {
    defaultMessage: 'Use a query to select services for this group. The preview shows services that match this query within the last 24 hours.'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_kuery_bar.KueryBar, {
    placeholder: _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.kql', {
      defaultMessage: 'E.g. labels.team: "web"'
    }),
    onSubmit: handleOnSubmit,
    onChange: value => {
      setStagedKuery(value);
    },
    value: kuery,
    suggestionFilter: querySuggestion => {
      if ('field' in querySuggestion) {
        const {
          field: {
            spec: {
              name: fieldName
            }
          }
        } = querySuggestion;
        return (0, _service_groups.isSupportedField)(fieldName);
      }
      return true;
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSelectServicesButton",
    onClick: handleOnSubmit,
    iconType: !kuery ? 'search' : 'refresh',
    isDisabled: isServiceListPreviewLoading || !stagedKuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, !kuery ? _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.preview', {
    defaultMessage: 'Preview'
  }) : _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.refresh', {
    defaultMessage: 'Refresh'
  })))), kuery && (data === null || data === void 0 ? void 0 : data.items) && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "success",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.matchingServiceCount', {
    defaultMessage: '{servicesCount} {servicesCount, plural, =0 {services} one {service} other {services}} match the query',
    values: {
      servicesCount: data === null || data === void 0 ? void 0 : data.items.length
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalBody, {
    style: {
      height: `calc(75vh - ${MODAL_HEADER_HEIGHT}px - ${MODAL_FOOTER_HEIGHT}px)`,
      maxHeight: MAX_CONTAINER_HEIGHT - MODAL_HEADER_HEIGHT - MODAL_FOOTER_HEIGHT
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    style: {
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }, !data && isServiceListPreviewLoading && /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 56
    }
  }), kueryValidationMessage !== null && kueryValidationMessage !== void 0 && kueryValidationMessage.length ? /*#__PURE__*/_react2.default.createElement(CentralizedContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.searchResults.error', {
      defaultMessage: 'Error retrieving search results'
    }),
    color: "danger",
    iconType: "error",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    css: (0, _react.css)`
                        white-space: break-spaces;
                        font-family: ${euiTheme.font.familyCode};
                      `,
    "data-test-subj": "discoverErrorCalloutMessage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 21
    }
  }, kueryValidationMessage))) : kuery && data ? /*#__PURE__*/_react2.default.createElement(_service_list_preview.ServiceListPreview, {
    items: data.items,
    isLoading: isServiceListPreviewLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react2.default.createElement(CentralizedContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.panelLabel', {
    defaultMessage: 'Enter a query to select services'
  }))))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSelectServicesEditGroupDetailsButton",
    color: "text",
    onClick: onEditGroupDetailsClick,
    iconType: "sortLeft",
    isDisabled: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.editGroupDetails', {
    defaultMessage: 'Edit group details'
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmSelectServicesCancelButton",
    onClick: onCloseModal,
    isDisabled: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSelectServicesSaveGroupButton",
    fill: true,
    onClick: () => {
      onSaveClick({
        ...serviceGroup,
        kuery
      });
    },
    isDisabled: isLoading || !kuery || !(0, _lodash.isEmpty)(kueryValidationMessage),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.saveGroup', {
    defaultMessage: 'Save group'
  }))))));
}