"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMigrations870 = void 0;
var _constants = require("../../../rules_client/common/constants");
var _utils = require("../utils");
var _types = require("../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function addGroupByToEsQueryRule(doc) {
  // Adding another check in for isEsQueryRuleType in case we add more migrations
  if ((0, _utils.isEsQueryRuleType)(doc)) {
    return {
      ...doc,
      attributes: {
        ...doc.attributes,
        params: {
          ...doc.attributes.params,
          aggType: 'count',
          groupBy: 'all'
        }
      }
    };
  }
  return doc;
}
function addLogViewRefToLogThresholdRule(doc) {
  if ((0, _utils.isLogThresholdRuleType)(doc)) {
    var _doc$references;
    const references = (_doc$references = doc.references) !== null && _doc$references !== void 0 ? _doc$references : [];
    const logViewId = 'log-view-reference-0';
    return {
      ...doc,
      attributes: {
        ...doc.attributes,
        params: {
          ...doc.attributes.params,
          logView: {
            logViewId,
            type: 'log-view-reference'
          }
        }
      },
      references: [...references, {
        name: `${_constants.extractedSavedObjectParamReferenceNamePrefix}${logViewId}`,
        type: 'infrastructure-monitoring-log-view',
        id: 'default'
      }]
    };
  }
  return doc;
}
function addOutcomeOrder(doc) {
  if (!doc.attributes.lastRun) {
    return doc;
  }
  const outcome = doc.attributes.lastRun.outcome;
  return {
    ...doc,
    attributes: {
      ...doc.attributes,
      lastRun: {
        ...doc.attributes.lastRun,
        outcomeOrder: _types.RuleLastRunOutcomeOrderMap[outcome]
      }
    }
  };
}
const getMigrations870 = encryptedSavedObjects => (0, _utils.createEsoMigration)(encryptedSavedObjects, doc => true, (0, _utils.pipeMigrations)(addGroupByToEsQueryRule, addLogViewRefToLogThresholdRule, addOutcomeOrder));
exports.getMigrations870 = getMigrations870;