"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceReferenceManager = void 0;
/**
 * Manages references to core services used throughout the Container
 * This class allows for proper synchronization of services during snapshot/restore operations
 */
class ServiceReferenceManager {
    activationService;
    bindingService;
    deactivationService;
    planResultCacheService;
    #onResetComputedPropertiesListeners;
    constructor(activationService, bindingService, deactivationService, planResultCacheService) {
        this.activationService = activationService;
        this.bindingService = bindingService;
        this.deactivationService = deactivationService;
        this.planResultCacheService = planResultCacheService;
        this.#onResetComputedPropertiesListeners = [];
    }
    reset(activationService, bindingService, deactivationService) {
        this.activationService = activationService;
        this.bindingService = bindingService;
        this.deactivationService = deactivationService;
        this.planResultCacheService.clearCache();
        for (const listener of this.#onResetComputedPropertiesListeners) {
            listener();
        }
    }
    onReset(listener) {
        this.#onResetComputedPropertiesListeners.push(listener);
    }
}
exports.ServiceReferenceManager = ServiceReferenceManager;
//# sourceMappingURL=ServiceReferenceManager.js.map