/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.rest.ESRestTestCase;

class VersionRange {
    static final Predicate<Set<String>> NEVER = Predicates.never();
    static final Predicate<Set<String>> ALWAYS = Predicates.always();
    static final Predicate<Set<String>> CURRENT = versions -> versions.size() == 1 && versions.contains(Build.current().version());
    static final Predicate<Set<String>> NON_CURRENT = CURRENT.negate();
    static final Predicate<Set<String>> MIXED = versions -> versions.size() > 1;

    private VersionRange() {
    }

    static List<Predicate<Set<String>>> parseVersionRanges(String rawRanges) {
        if (rawRanges == null) {
            return List.of(NEVER);
        }
        if (rawRanges.trim().equals("all")) {
            return List.of(ALWAYS);
        }
        if (rawRanges.trim().equals("current")) {
            return List.of(CURRENT);
        }
        if (rawRanges.trim().equals("non_current")) {
            return List.of(NON_CURRENT);
        }
        if (rawRanges.trim().equals("mixed")) {
            return List.of(MIXED);
        }
        String[] ranges = rawRanges.split(",");
        ArrayList<Predicate<Set<String>>> versionRanges = new ArrayList<Predicate<Set<String>>>();
        for (String rawRange : ranges) {
            String[] skipVersions = rawRange.split("-", -1);
            if (skipVersions.length > 2) {
                throw new IllegalArgumentException("version range malformed: " + rawRanges);
            }
            String lower = skipVersions[0].trim();
            String upper = skipVersions[1].trim();
            MinimumContainedInVersionRange minimumContainedInVersionRange = new MinimumContainedInVersionRange(lower.isEmpty() ? VersionUtils.getFirstVersion() : Version.fromString((String)lower), upper.isEmpty() ? Version.CURRENT : Version.fromString((String)upper));
            versionRanges.add(minimumContainedInVersionRange);
        }
        return versionRanges;
    }

    static class MinimumContainedInVersionRange
    implements Predicate<Set<String>> {
        final Version lower;
        final Version upper;

        private MinimumContainedInVersionRange(Version lower, Version upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean test(Set<String> nodesVersions) {
            Version minimumNodeVersion = (Version)nodesVersions.stream().map(ESRestTestCase::parseLegacyVersion).flatMap(Optional::stream).min(Comparator.naturalOrder()).orElseThrow(() -> new IllegalArgumentException("Checks against a version range require semantic version format (x.y.z)"));
            return minimumNodeVersion.onOrAfter((VersionId)this.lower) && minimumNodeVersion.onOrBefore((VersionId)this.upper);
        }

        public String toString() {
            return "MinimumContainedInVersionRange{lower=" + String.valueOf(this.lower) + ", upper=" + String.valueOf(this.upper) + "}";
        }
    }
}

