/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ExistsAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(ExistsAssertion.class);

    public static ExistsAssertion parse(XContentParser parser) throws IOException {
        return new ExistsAssertion(parser.getTokenLocation(), ParserUtils.parseField(parser));
    }

    public ExistsAssertion(XContentLocation location, String field) {
        super(location, field, true);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that field [{}] exists with any value", (Object)this.getField());
        String errorMessage = this.errorMessage();
        Assert.assertThat((String)errorMessage, (Object)actualValue, (Matcher)Matchers.notNullValue());
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] does not exist";
    }
}

