/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.restspec;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class ClientYamlSuiteRestApiParser {
    private static final ObjectParser<Parameter, Void> PARAMETER_PARSER = new ObjectParser("parameter", true, Parameter::new);

    public ClientYamlSuiteRestApi parse(String location, XContentParser parser) throws IOException {
        while (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            if (parser.currentToken() != null) continue;
            throw new ParsingException(parser.getTokenLocation(), "Invalid rest spec file found at [" + location + "]. No API name found in file", new Object[0]);
        }
        String apiName = parser.currentName();
        if (!location.endsWith(apiName + ".json")) {
            throw new IllegalArgumentException("API [" + apiName + "] should have the same name as its file [" + location + "]");
        }
        if (apiName.chars().filter(c -> c == 46).count() > 1L) {
            throw new IllegalArgumentException("API [" + apiName + "] contains more then one namespace [" + location + "]");
        }
        ClientYamlSuiteRestApi restApi = new ClientYamlSuiteRestApi(location, apiName);
        int level = -1;
        while (parser.nextToken() != XContentParser.Token.END_OBJECT || level >= 0) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                if ("documentation".equals(parser.currentName())) {
                    parser.nextToken();
                    parser.skipChildren();
                } else if ("headers".equals(parser.currentName())) {
                    assert (parser.nextToken() == XContentParser.Token.START_OBJECT);
                    String headerName = null;
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                            headerName = parser.currentName();
                        }
                        if (headerName.equals("accept")) {
                            if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                                throw new ParsingException(parser.getTokenLocation(), apiName + " API: [headers.accept] must be an array", new Object[0]);
                            }
                            List<String> acceptMimeTypes = ClientYamlSuiteRestApiParser.getStringsFromArray(parser, "accept");
                            restApi.setResponseMimeTypes(acceptMimeTypes);
                            continue;
                        }
                        if (!headerName.equals("content_type")) continue;
                        if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                            throw new ParsingException(parser.getTokenLocation(), apiName + " API: [headers.content_type] must be an array", new Object[0]);
                        }
                        List<String> requestMimeTypes = ClientYamlSuiteRestApiParser.getStringsFromArray(parser, "content_type");
                        restApi.setRequestMimeTypes(requestMimeTypes);
                    }
                } else if ("stability".equals(parser.currentName())) {
                    parser.nextToken();
                    restApi.setStability(parser.textOrNull());
                } else if ("visibility".equals(parser.currentName())) {
                    parser.nextToken();
                    restApi.setVisibility(parser.textOrNull());
                } else if ("feature_flag".equals(parser.currentName())) {
                    parser.nextToken();
                    restApi.setFeatureFlag(parser.textOrNull());
                } else if ("deprecated".equals(parser.currentName())) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new ParsingException(parser.getTokenLocation(), apiName + " API: expected [deprecated] field in rest api definition to hold an object", new Object[0]);
                    }
                    parser.skipChildren();
                } else if ("url".equals(parser.currentName())) {
                    String currentFieldName = null;
                    assert (parser.nextToken() == XContentParser.Token.START_OBJECT);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                        }
                        if ("paths".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                                throw new ParsingException(parser.getTokenLocation(), apiName + " API: [paths] must be an array", new Object[0]);
                            }
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                String path = null;
                                HashSet<String> methods = new HashSet<String>();
                                HashSet<String> pathParts = new HashSet<String>();
                                boolean deprecated = false;
                                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                    if ("path".equals(parser.currentName())) {
                                        parser.nextToken();
                                        path = parser.text();
                                        continue;
                                    }
                                    if ("methods".equals(parser.currentName())) {
                                        if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                                            throw new ParsingException(parser.getTokenLocation(), apiName + " API: expected [methods] field in rest api definition to hold an array", new Object[0]);
                                        }
                                        while (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
                                            String method = parser.text();
                                            if (methods.add(method)) continue;
                                            throw new ParsingException(parser.getTokenLocation(), apiName + " API: found duplicate method [" + method + "]", new Object[0]);
                                        }
                                        continue;
                                    }
                                    if ("parts".equals(parser.currentName())) {
                                        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                                            throw new ParsingException(parser.getTokenLocation(), apiName + " API: expected [parts] field in rest api definition to hold an object", new Object[0]);
                                        }
                                        while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                                            String part = parser.currentName();
                                            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                                                throw new ParsingException(parser.getTokenLocation(), apiName + " API: expected [parts] field in rest api definition to contain an object", new Object[0]);
                                            }
                                            parser.skipChildren();
                                            if (pathParts.add(part)) continue;
                                            throw new ParsingException(parser.getTokenLocation(), apiName + " API: duplicated path part [" + part + "]", new Object[0]);
                                        }
                                        continue;
                                    }
                                    if ("deprecated".equals(parser.currentName())) {
                                        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                                            throw new ParsingException(parser.getTokenLocation(), apiName + " API: expected [deprecated] field in rest api definition to hold an object", new Object[0]);
                                        }
                                        deprecated = true;
                                        parser.skipChildren();
                                        continue;
                                    }
                                    throw new ParsingException(parser.getTokenLocation(), apiName + " API: unexpected field [" + parser.currentName() + "] of type [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
                                }
                                restApi.addPath(path, methods.toArray(new String[0]), pathParts, deprecated);
                            }
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), apiName + " API: unsupported field [" + parser.currentName() + "]", new Object[0]);
                    }
                } else if ("params".equals(parser.currentName())) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new ParsingException(parser.getTokenLocation(), apiName + " API: expected [params] field in rest api definition to contain an object", new Object[0]);
                    }
                    while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                        String param = parser.currentName();
                        parser.nextToken();
                        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                            throw new ParsingException(parser.getTokenLocation(), apiName + " API: expected [params] field in rest api definition to contain an object", new Object[0]);
                        }
                        restApi.addParam(param, ((Parameter)PARAMETER_PARSER.parse(parser, null)).isRequired());
                    }
                } else if ("body".equals(parser.currentName())) {
                    parser.nextToken();
                    if (parser.currentToken() != XContentParser.Token.VALUE_NULL) {
                        boolean requiredFound = false;
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (parser.currentToken() != XContentParser.Token.FIELD_NAME || !"required".equals(parser.currentName())) continue;
                            requiredFound = true;
                            parser.nextToken();
                            if (parser.booleanValue()) {
                                restApi.setBodyRequired();
                                continue;
                            }
                            restApi.setBodyOptional();
                        }
                        if (!requiredFound) {
                            restApi.setBodyOptional();
                        }
                    }
                } else {
                    throw new ParsingException(parser.getTokenLocation(), apiName + " API: unsupported field [" + parser.currentName() + "]", new Object[0]);
                }
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                ++level;
            }
            if (parser.currentToken() != XContentParser.Token.END_OBJECT) continue;
            --level;
        }
        parser.nextToken();
        assert (parser.currentToken() == XContentParser.Token.END_OBJECT) : "Expected [END_OBJECT] but was [" + String.valueOf(parser.currentToken()) + "]";
        parser.nextToken();
        if (restApi.getPaths().isEmpty()) {
            throw new IllegalArgumentException(apiName + " API: at least one path should be listed under [paths]");
        }
        if (restApi.getStability() == null) {
            throw new IllegalArgumentException(apiName + " API does not declare its stability in [" + location + "]");
        }
        if (restApi.getVisibility() == null) {
            throw new IllegalArgumentException(apiName + " API does not declare its visibility explicitly in [" + location + "]");
        }
        if (restApi.getVisibility() == ClientYamlSuiteRestApi.Visibility.FEATURE_FLAG && (restApi.getFeatureFlag() == null || restApi.getFeatureFlag().isEmpty())) {
            throw new IllegalArgumentException(apiName + " API has visibility `feature_flag` but does not document its feature flag in [" + location + "]");
        }
        if (restApi.getFeatureFlag() != null && restApi.getVisibility() != ClientYamlSuiteRestApi.Visibility.FEATURE_FLAG) {
            throw new IllegalArgumentException(apiName + " API does not have visibility `feature_flag` but documents a feature flag [" + location + "]");
        }
        return restApi;
    }

    private static List<String> getStringsFromArray(XContentParser parser, String key) throws IOException {
        return parser.list().stream().filter(Objects::nonNull).map(o -> {
            if (o instanceof String) {
                return (String)o;
            }
            throw new XContentParseException(key + " array may only contain strings but found [" + o.getClass().getName() + "] [" + String.valueOf(o) + "]");
        }).collect(Collectors.toList());
    }

    static {
        PARAMETER_PARSER.declareBoolean(Parameter::setRequired, new ParseField("required", new String[0]));
    }

    private static class Parameter {
        private boolean required;

        private Parameter() {
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }
    }
}

