/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.esql.action.EsqlListQueriesRequest;
import org.elasticsearch.xpack.esql.core.async.AsyncTaskManagementService;
import org.elasticsearch.xpack.esql.plugin.EsqlListQueriesResponse;
import org.elasticsearch.xpack.esql.plugin.EsqlQueryStatus;

public class TransportEsqlListQueriesAction
extends HandledTransportAction<EsqlListQueriesRequest, EsqlListQueriesResponse> {
    private final NodeClient nodeClient;

    @Inject
    public TransportEsqlListQueriesAction(TransportService transportService, NodeClient nodeClient, ActionFilters actionFilters) {
        super("cluster:monitor/xpack/esql/list_queries", transportService, actionFilters, EsqlListQueriesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nodeClient = nodeClient;
    }

    protected void doExecute(Task task, EsqlListQueriesRequest request, final ActionListener<EsqlListQueriesResponse> listener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.nodeClient, (String)"esql", (ActionType)TransportListTasksAction.TYPE, (ActionRequest)((ListTasksRequest)new ListTasksRequest().setActions(new String[]{"indices:data/read/esql", "indices:data/read/esql" + AsyncTaskManagementService.ASYNC_ACTION_SUFFIX})).setDetailed(true), (ActionListener)new ActionListener<ListTasksResponse>(this){

            public void onResponse(ListTasksResponse response) {
                List<EsqlListQueriesResponse.Query> queries = response.getTasks().stream().map(TransportEsqlListQueriesAction::toQuery).toList();
                listener.onResponse((Object)new EsqlListQueriesResponse(queries));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private static EsqlListQueriesResponse.Query toQuery(TaskInfo taskInfo) {
        return new EsqlListQueriesResponse.Query(((EsqlQueryStatus)taskInfo.status()).id(), taskInfo.startTime(), taskInfo.runningTimeNanos(), taskInfo.description());
    }
}

