/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.MediaTypeRegistry;
import org.elasticsearch.xcontent.ParsedMediaType;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.arrow.ArrowFormat;
import org.elasticsearch.xpack.esql.formatter.TextFormat;

public class EsqlMediaTypeParser {
    public static final MediaTypeRegistry<? extends MediaType> MEDIA_TYPE_REGISTRY = new MediaTypeRegistry().register((MediaType[])XContentType.values()).register((MediaType[])TextFormat.values()).register(new MediaType[]{ArrowFormat.INSTANCE});

    public static MediaType getResponseMediaType(RestRequest request, EsqlQueryRequest esqlRequest) {
        MediaType mediaType = EsqlMediaTypeParser.getResponseMediaType(request, (MediaType)null);
        EsqlMediaTypeParser.validateColumnarRequest(esqlRequest.columnar(), mediaType);
        EsqlMediaTypeParser.validateIncludeCCSMetadata(esqlRequest.includeCCSMetadata(), mediaType);
        EsqlMediaTypeParser.validateIncludeExecutionMetadata(esqlRequest.includeExecutionMetadata(), mediaType);
        EsqlMediaTypeParser.validateProfile(esqlRequest.profile(), mediaType);
        return EsqlMediaTypeParser.checkNonNullMediaType(mediaType, request);
    }

    public static MediaType getResponseMediaType(RestRequest request, MediaType defaultMediaType) {
        MediaType mediaType = request.hasParam("format") ? EsqlMediaTypeParser.mediaTypeFromParams(request) : EsqlMediaTypeParser.mediaTypeFromHeaders(request);
        return mediaType == null ? defaultMediaType : mediaType;
    }

    private static MediaType mediaTypeFromHeaders(RestRequest request) {
        ParsedMediaType acceptType = request.getParsedAccept();
        return acceptType != null ? acceptType.toMediaType(MEDIA_TYPE_REGISTRY) : request.getXContentType();
    }

    private static MediaType mediaTypeFromParams(RestRequest request) {
        return MEDIA_TYPE_REGISTRY.queryParamToMediaType(request.param("format"));
    }

    private static void validateColumnarRequest(boolean requestIsColumnar, MediaType fromMediaType) {
        if (requestIsColumnar && fromMediaType instanceof TextFormat) {
            throw EsqlMediaTypeParser.invalid("columnar");
        }
    }

    private static void validateIncludeCCSMetadata(Boolean includeCCSMetadata, MediaType fromMediaType) {
        if (Boolean.TRUE.equals(includeCCSMetadata) && fromMediaType instanceof TextFormat) {
            throw EsqlMediaTypeParser.invalid("include_ccs_metadata");
        }
    }

    private static void validateIncludeExecutionMetadata(Boolean includeExecutionMetadata, MediaType fromMediaType) {
        if (Boolean.TRUE.equals(includeExecutionMetadata) && fromMediaType instanceof TextFormat) {
            throw EsqlMediaTypeParser.invalid("include_execution_metadata");
        }
    }

    private static void validateProfile(boolean profile, MediaType fromMediaType) {
        if (profile && fromMediaType instanceof TextFormat) {
            throw EsqlMediaTypeParser.invalid("profile");
        }
    }

    private static IllegalArgumentException invalid(String argument) {
        return new IllegalArgumentException("Invalid use of [" + argument + "] argument: cannot be used in combination with " + String.valueOf(Arrays.stream(TextFormat.values()).map(MediaType::queryParameter).toList()) + " formats");
    }

    private static MediaType checkNonNullMediaType(MediaType mediaType, RestRequest request) {
        if (mediaType == null) {
            String msg = String.format(Locale.ROOT, "Invalid request content type: Accept=[%s], Content-Type=[%s], format=[%s]", request.header("Accept"), request.header("Content-Type"), request.param("format"));
            throw new IllegalArgumentException(msg);
        }
        return mediaType;
    }
}

