/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.Queries;
import org.elasticsearch.xpack.esql.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.expression.predicate.Range;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class PushFiltersToSource
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<FilterExec, LocalPhysicalOptimizerContext> {
    @Override
    protected PhysicalPlan rule(FilterExec filterExec, LocalPhysicalOptimizerContext ctx) {
        PhysicalPlan plan = filterExec;
        PhysicalPlan physicalPlan = filterExec.child();
        if (physicalPlan instanceof EsQueryExec) {
            EsQueryExec queryExec = (EsQueryExec)physicalPlan;
            plan = PushFiltersToSource.planFilterExec(filterExec, queryExec, ctx);
        } else {
            EvalExec evalExec;
            physicalPlan = filterExec.child();
            if (physicalPlan instanceof EvalExec && (physicalPlan = (evalExec = (EvalExec)physicalPlan).child()) instanceof EsQueryExec) {
                EsQueryExec queryExec = (EsQueryExec)physicalPlan;
                plan = PushFiltersToSource.planFilterExec(filterExec, evalExec, queryExec, ctx);
            }
        }
        return plan;
    }

    private static PhysicalPlan planFilterExec(FilterExec filterExec, EsQueryExec queryExec, LocalPhysicalOptimizerContext ctx) {
        LucenePushdownPredicates pushdownPredicates = LucenePushdownPredicates.from(ctx.searchStats(), ctx.flags());
        ArrayList<Expression> pushable = new ArrayList<Expression>();
        ArrayList<Expression> nonPushable = new ArrayList<Expression>();
        for (Expression exp : Predicates.splitAnd(filterExec.condition())) {
            switch (TranslationAware.translatable(exp, pushdownPredicates).finish()) {
                case NO: {
                    nonPushable.add(exp);
                    break;
                }
                case YES: {
                    pushable.add(exp);
                    break;
                }
                case RECHECK: {
                    pushable.add(exp);
                    nonPushable.add(exp);
                }
            }
        }
        return PushFiltersToSource.rewrite(pushdownPredicates, filterExec, queryExec, pushable, nonPushable, List.of());
    }

    private static PhysicalPlan planFilterExec(FilterExec filterExec, EvalExec evalExec, EsQueryExec queryExec, LocalPhysicalOptimizerContext ctx) {
        LucenePushdownPredicates pushdownPredicates = LucenePushdownPredicates.from(ctx.searchStats(), ctx.flags());
        AttributeMap<Attribute> aliasReplacedBy = PushFiltersToSource.getAliasReplacedBy(evalExec);
        ArrayList<Expression> pushable = new ArrayList<Expression>();
        ArrayList<Expression> nonPushable = new ArrayList<Expression>();
        for (Expression exp : Predicates.splitAnd(filterExec.condition())) {
            Expression resExp = (Expression)exp.transformUp(ReferenceAttribute.class, r -> (Expression)aliasReplacedBy.resolve(r, r));
            switch (TranslationAware.translatable(resExp, pushdownPredicates).finish()) {
                case NO: {
                    nonPushable.add(exp);
                    break;
                }
                case YES: {
                    pushable.add(exp);
                    break;
                }
                case RECHECK: {
                    nonPushable.add(exp);
                    nonPushable.add(exp);
                }
            }
        }
        pushable.replaceAll(e -> (Expression)e.transformDown(ReferenceAttribute.class, r -> (Expression)aliasReplacedBy.resolve(r, r)));
        return PushFiltersToSource.rewrite(pushdownPredicates, filterExec, queryExec, pushable, nonPushable, evalExec.fields());
    }

    static AttributeMap<Attribute> getAliasReplacedBy(EvalExec evalExec) {
        AttributeMap.Builder aliasReplacedByBuilder = AttributeMap.builder();
        evalExec.fields().forEach(alias -> {
            Expression patt0$temp = alias.child();
            if (patt0$temp instanceof Attribute) {
                Attribute attr = (Attribute)patt0$temp;
                aliasReplacedByBuilder.put(alias.toAttribute(), (Object)attr);
            }
        });
        return aliasReplacedByBuilder.build();
    }

    private static PhysicalPlan rewrite(LucenePushdownPredicates pushdownPredicates, FilterExec filterExec, EsQueryExec queryExec, List<Expression> pushable, List<Expression> nonPushable, List<Alias> evalFields) {
        List<Expression> newPushable = PushFiltersToSource.combineEligiblePushableToRange(pushable);
        if (newPushable.size() > 0) {
            PhysicalPlan plan;
            Query queryDSL = TranslatorHandler.TRANSLATOR_HANDLER.asQuery(pushdownPredicates, Predicates.combineAnd(newPushable));
            QueryBuilder planQuery = queryDSL.toQueryBuilder();
            Queries.Clause combiningQueryClauseType = queryExec.hasScoring() ? Queries.Clause.MUST : Queries.Clause.FILTER;
            QueryBuilder query = Queries.combine((Queries.Clause)combiningQueryClauseType, Arrays.asList(queryExec.query(), planQuery));
            queryExec = new EsQueryExec(queryExec.source(), queryExec.indexPattern(), queryExec.indexMode(), queryExec.indexNameWithModes(), queryExec.output(), queryExec.limit(), queryExec.sorts(), queryExec.estimatedRowSize(), List.of(new EsQueryExec.QueryBuilderAndTags(query, List.of())));
            PhysicalPlan physicalPlan = plan = evalFields.isEmpty() ? queryExec : new EvalExec(filterExec.source(), queryExec, evalFields);
            if (nonPushable.size() > 0) {
                return new FilterExec(filterExec.source(), plan, Predicates.combineAnd(nonPushable));
            }
            return plan;
        }
        return filterExec;
    }

    private static List<Expression> combineEligiblePushableToRange(List<Expression> pushable) {
        ArrayList bcs = new ArrayList();
        ArrayList<Range> ranges = new ArrayList<Range>();
        ArrayList others = new ArrayList();
        boolean changed = false;
        pushable.forEach(e -> {
            if (e instanceof GreaterThan || e instanceof GreaterThanOrEqual || e instanceof LessThan || e instanceof LessThanOrEqual) {
                if (((EsqlBinaryComparison)e).right().foldable()) {
                    bcs.add((EsqlBinaryComparison)e);
                } else {
                    others.add(e);
                }
            } else {
                others.add(e);
            }
        });
        int step = 1;
        for (int i = 0; i < bcs.size() - 1; i += step) {
            BinaryComparison main = (BinaryComparison)bcs.get(i);
            for (int j = i + 1; j < bcs.size(); ++j) {
                BinaryComparison other = (BinaryComparison)bcs.get(j);
                if (!main.left().semanticEquals(other.left())) continue;
                if ((main instanceof GreaterThan || main instanceof GreaterThanOrEqual) && (other instanceof LessThan || other instanceof LessThanOrEqual)) {
                    bcs.remove(j);
                    bcs.remove(i);
                    ranges.add(new Range(main.source(), main.left(), main.right(), main instanceof GreaterThanOrEqual, other.right(), other instanceof LessThanOrEqual, main.zoneId()));
                    changed = true;
                    step = 0;
                    break;
                }
                if (!(other instanceof GreaterThan) && !(other instanceof GreaterThanOrEqual) || !(main instanceof LessThan) && !(main instanceof LessThanOrEqual)) continue;
                bcs.remove(j);
                bcs.remove(i);
                ranges.add(new Range(main.source(), main.left(), other.right(), other instanceof GreaterThanOrEqual, main.right(), main instanceof LessThanOrEqual, main.zoneId()));
                changed = true;
                step = 0;
                break;
            }
            step = 1;
        }
        return changed ? CollectionUtils.combine((Collection[])new Collection[]{others, bcs, ranges}) : pushable;
    }
}

