/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.expression.function.vector.Knn;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.score.ExpressionScoreMapper;

public class PushDownConjunctionsToKnnPrefilters
extends OptimizerRules.OptimizerRule<Filter> {
    @Override
    protected LogicalPlan rule(Filter filter) {
        Expression newCondition;
        Stack<Expression> filters = new Stack<Expression>();
        Expression condition = filter.condition();
        return condition.equals((Object)(newCondition = PushDownConjunctionsToKnnPrefilters.pushConjunctionsToKnn(condition, filters, null))) ? filter : filter.with(newCondition);
    }

    private static Expression pushConjunctionsToKnn(Expression expression, Stack<Expression> filters, Expression addedFilter) {
        Knn result;
        if (addedFilter != null) {
            filters.push(addedFilter);
        }
        Expression expression2 = expression;
        Objects.requireNonNull(expression2);
        Expression expression3 = expression2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{And.class, Knn.class}, (Object)expression3, n)) {
            case 0: {
                ExpressionScoreMapper expressionScoreMapper;
                And and = (And)expression3;
                Expression newLeft = PushDownConjunctionsToKnnPrefilters.pushConjunctionsToKnn(and.left(), filters, and.right());
                Expression newRight = PushDownConjunctionsToKnnPrefilters.pushConjunctionsToKnn(and.right(), filters, and.left());
                if (newLeft.equals((Object)and.left()) && newRight.equals((Object)and.right())) {
                    expressionScoreMapper = and;
                    break;
                }
                expressionScoreMapper = (Expression)and.replaceChildrenSameSize(List.of(newLeft, newRight));
                break;
            }
            case 1: {
                ExpressionScoreMapper expressionScoreMapper;
                Knn knn = (Knn)expression3;
                List<Expression> newFilters = filters.stream().map(PushDownConjunctionsToKnnPrefilters::removeKnn).filter(Objects::nonNull).toList();
                if (newFilters.equals(knn.filterExpressions())) {
                    expressionScoreMapper = knn;
                    break;
                }
                expressionScoreMapper = knn.withFilters(newFilters);
                break;
            }
            default: {
                List children = expression.children();
                boolean childrenChanged = false;
                ArrayList<Expression> transformedChildren = null;
                int s = children.size();
                for (int i = 0; i < s; ++i) {
                    Expression next;
                    Expression child = (Expression)children.get(i);
                    if (child.equals((Object)(next = PushDownConjunctionsToKnnPrefilters.pushConjunctionsToKnn(child, filters, null)))) continue;
                    if (!childrenChanged) {
                        childrenChanged = true;
                        transformedChildren = new ArrayList<Expression>(children);
                    }
                    transformedChildren.set(i, next);
                }
                ExpressionScoreMapper expressionScoreMapper = result = childrenChanged ? (Expression)expression.replaceChildrenSameSize(transformedChildren) : expression;
            }
        }
        if (addedFilter != null) {
            filters.pop();
        }
        return result;
    }

    private static Expression removeKnn(Expression expression) {
        if (expression.children().isEmpty()) {
            return expression;
        }
        if (expression instanceof Knn) {
            return null;
        }
        List<Expression> filteredChildren = expression.children().stream().map(PushDownConjunctionsToKnnPrefilters::removeKnn).filter(Objects::nonNull).toList();
        if (filteredChildren.equals(expression.children())) {
            return expression;
        }
        if (filteredChildren.isEmpty()) {
            return null;
        }
        if (expression instanceof BinaryLogic && filteredChildren.size() == 1) {
            return filteredChildren.getFirst();
        }
        return (Expression)expression.replaceChildrenSameSize(filteredChildren);
    }
}

