/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersects;

public final class SpatialIntersectsGeoSourceAndConstantGridEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SpatialIntersectsGeoSourceAndConstantGridEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator wkb;
    private final long gridId;
    private final DataType gridType;
    private final DriverContext driverContext;
    private Warnings warnings;

    public SpatialIntersectsGeoSourceAndConstantGridEvaluator(Source source, EvalOperator.ExpressionEvaluator wkb, long gridId, DataType gridType, DriverContext driverContext) {
        this.source = source;
        this.wkb = wkb;
        this.gridId = gridId;
        this.gridType = gridType;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock wkbBlock = (BytesRefBlock)this.wkb.eval(page);){
            BooleanBlock booleanBlock = this.eval(page.getPositionCount(), wkbBlock);
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.wkb.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock wkbBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!wkbBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    SpatialIntersects.processGeoSourceAndConstantGrid(result, p, wkbBlock, this.gridId, this.gridType);
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.warnings().registerException(e);
                    result.appendNull();
                }
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "SpatialIntersectsGeoSourceAndConstantGridEvaluator[wkb=" + String.valueOf(this.wkb) + ", gridId=" + this.gridId + ", gridType=" + String.valueOf(this.gridType) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.wkb);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory wkb;
        private final long gridId;
        private final DataType gridType;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory wkb, long gridId, DataType gridType) {
            this.source = source;
            this.wkb = wkb;
            this.gridId = gridId;
            this.gridType = gridType;
        }

        public SpatialIntersectsGeoSourceAndConstantGridEvaluator get(DriverContext context) {
            return new SpatialIntersectsGeoSourceAndConstantGridEvaluator(this.source, this.wkb.get(context), this.gridId, this.gridType, context);
        }

        public String toString() {
            return "SpatialIntersectsGeoSourceAndConstantGridEvaluator[wkb=" + String.valueOf(this.wkb) + ", gridId=" + this.gridId + ", gridType=" + String.valueOf(this.gridType) + "]";
        }
    }
}

