/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Scalb;

public final class ScalbIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ScalbIntEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator d;
    private final EvalOperator.ExpressionEvaluator scaleFactor;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ScalbIntEvaluator(Source source, EvalOperator.ExpressionEvaluator d, EvalOperator.ExpressionEvaluator scaleFactor, DriverContext driverContext) {
        this.source = source;
        this.d = d;
        this.scaleFactor = scaleFactor;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock dBlock = (DoubleBlock)this.d.eval(page);){
            DoubleBlock doubleBlock;
            block20: {
                IntVector scaleFactorVector;
                DoubleVector dVector;
                IntBlock scaleFactorBlock;
                block18: {
                    DoubleBlock doubleBlock2;
                    block19: {
                        block16: {
                            DoubleBlock doubleBlock3;
                            block17: {
                                scaleFactorBlock = (IntBlock)this.scaleFactor.eval(page);
                                try {
                                    dVector = dBlock.asVector();
                                    if (dVector != null) break block16;
                                    doubleBlock3 = this.eval(page.getPositionCount(), dBlock, scaleFactorBlock);
                                    if (scaleFactorBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (scaleFactorBlock != null) {
                                        try {
                                            scaleFactorBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                scaleFactorBlock.close();
                            }
                            return doubleBlock3;
                        }
                        scaleFactorVector = scaleFactorBlock.asVector();
                        if (scaleFactorVector != null) break block18;
                        doubleBlock2 = this.eval(page.getPositionCount(), dBlock, scaleFactorBlock);
                        if (scaleFactorBlock == null) break block19;
                        scaleFactorBlock.close();
                    }
                    return doubleBlock2;
                }
                doubleBlock = this.eval(page.getPositionCount(), dVector, scaleFactorVector);
                if (scaleFactorBlock == null) break block20;
                scaleFactorBlock.close();
            }
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.d.baseRamBytesUsed();
        return baseRamBytesUsed += this.scaleFactor.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, DoubleBlock dBlock, IntBlock scaleFactorBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (dBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (dBlock.getValueCount(p) != 1) {
                    if (dBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (scaleFactorBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (scaleFactorBlock.getValueCount(p) != 1) {
                    if (scaleFactorBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                double d = dBlock.getDouble(dBlock.getFirstValueIndex(p));
                int scaleFactor = scaleFactorBlock.getInt(scaleFactorBlock.getFirstValueIndex(p));
                try {
                    result.appendDouble(Scalb.process(d, scaleFactor));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleVector dVector, IntVector scaleFactorVector) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                double d = dVector.getDouble(p);
                int scaleFactor = scaleFactorVector.getInt(p);
                try {
                    result.appendDouble(Scalb.process(d, scaleFactor));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "ScalbIntEvaluator[d=" + String.valueOf(this.d) + ", scaleFactor=" + String.valueOf(this.scaleFactor) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.d, this.scaleFactor});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory d;
        private final EvalOperator.ExpressionEvaluator.Factory scaleFactor;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory d, EvalOperator.ExpressionEvaluator.Factory scaleFactor) {
            this.source = source;
            this.d = d;
            this.scaleFactor = scaleFactor;
        }

        public ScalbIntEvaluator get(DriverContext context) {
            return new ScalbIntEvaluator(this.source, this.d.get(context), this.scaleFactor.get(context), context);
        }

        public String toString() {
            return "ScalbIntEvaluator[d=" + String.valueOf(this.d) + ", scaleFactor=" + String.valueOf(this.scaleFactor) + "]";
        }
    }
}

