/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;

public final class CastIntToUnsignedLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CastIntToUnsignedLongEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;
    private Warnings warnings;

    public CastIntToUnsignedLongEvaluator(Source source, EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.source = source;
        this.v = v;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock vBlock = (IntBlock)this.v.eval(page);){
            IntVector vVector = vBlock.asVector();
            if (vVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), vBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), vVector).asBlock();
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.v.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, IntBlock vBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (vBlock.getValueCount(p) != 1) {
                    if (vBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                int v = vBlock.getInt(vBlock.getFirstValueIndex(p));
                result.appendLong(Cast.castIntToUnsignedLong(v));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, IntVector vVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int v = vVector.getInt(p);
                result.appendLong(p, Cast.castIntToUnsignedLong(v));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "CastIntToUnsignedLongEvaluator[v=" + String.valueOf(this.v) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory v;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory v) {
            this.source = source;
            this.v = v;
        }

        public CastIntToUnsignedLongEvaluator get(DriverContext context) {
            return new CastIntToUnsignedLongEvaluator(this.source, this.v.get(context), context);
        }

        public String toString() {
            return "CastIntToUnsignedLongEvaluator[v=" + String.valueOf(this.v) + "]";
        }
    }
}

