/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.inference;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.inference.InferenceFunction;

public class TextEmbedding
extends InferenceFunction<TextEmbedding> {
    private final Expression inferenceId;
    private final Expression inputText;

    @FunctionInfo(returnType={"dense_vector"}, description="Generates dense vector embeddings for text using a specified inference endpoint.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.DEVELOPMENT)}, preview=true, examples={@Example(description="Generate text embeddings using the 'test_dense_inference' inference endpoint.", file="text-embedding", tag="embedding-eval")})
    public TextEmbedding(Source source, @Param(name="text", type={"keyword"}, description="Text to generate embeddings from") Expression inputText, @Param(name="inference_id", type={"keyword"}, description="Identifier of the inference endpoint") Expression inferenceId) {
        super(source, List.of(inputText, inferenceId));
        this.inferenceId = inferenceId;
        this.inputText = inputText;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public Expression inputText() {
        return this.inputText;
    }

    @Override
    public Expression inferenceId() {
        return this.inferenceId;
    }

    public boolean foldable() {
        return this.inferenceId.foldable() && this.inputText.foldable();
    }

    public DataType dataType() {
        return DataType.DENSE_VECTOR;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution textResolution = TypeResolutions.isNotNull((Expression)this.inputText, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isFoldable((Expression)this.inputText, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST)).and(TypeResolutions.isType((Expression)this.inputText, arg_0 -> DataType.KEYWORD.equals(arg_0), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"string"}));
        if (textResolution.unresolved()) {
            return textResolution;
        }
        Expression.TypeResolution inferenceIdResolution = TypeResolutions.isNotNull((Expression)this.inferenceId, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isType((Expression)this.inferenceId, arg_0 -> DataType.KEYWORD.equals(arg_0), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"string"})).and(TypeResolutions.isFoldable((Expression)this.inferenceId, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
        if (inferenceIdResolution.unresolved()) {
            return inferenceIdResolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public TaskType taskType() {
        return TaskType.TEXT_EMBEDDING;
    }

    @Override
    public TextEmbedding withInferenceResolutionError(String inferenceId, String error) {
        return new TextEmbedding(this.source(), this.inputText, (Expression)new UnresolvedAttribute(this.inferenceId().source(), inferenceId, error));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new TextEmbedding(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, TextEmbedding::new, (Object)this.inputText, (Object)this.inferenceId);
    }

    public String toString() {
        return "TEXT_EMBEDDING(" + String.valueOf(this.inputText) + ", " + String.valueOf(this.inferenceId) + ")";
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextEmbedding textEmbedding = (TextEmbedding)((Object)o);
        return Objects.equals(this.inferenceId, textEmbedding.inferenceId) && Objects.equals(this.inputText, textEmbedding.inputText);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inferenceId, this.inputText);
    }
}

