/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.usage;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SearchUsage {
    public final String RETRIEVERS_NAME = "retrievers";
    private final Set<String> queries = new HashSet<String>();
    private final Set<String> rescorers = new HashSet<String>();
    private final Set<String> sections = new HashSet<String>();
    private final Set<String> retrievers = new HashSet<String>();
    private final ExtendedUsageTracker extendedUsage = new ExtendedUsageTracker();

    public void trackQueryUsage(String query) {
        this.queries.add(query);
    }

    public void trackSectionUsage(String section) {
        this.sections.add(section);
    }

    public void trackRescorerUsage(String name) {
        this.rescorers.add(name);
    }

    public void trackRetrieverUsage(String retriever) {
        this.retrievers.add(retriever);
        this.extendedUsage.initialize("retrievers", retriever);
    }

    private void trackExtendedDataUsage(String category, String name, Set<String> values) {
        this.extendedUsage.track(category, name, values);
    }

    public void trackRetrieverExtendedDataUsage(String name, Set<String> values) {
        this.trackExtendedDataUsage("retrievers", name, values);
    }

    public Set<String> getQueryUsage() {
        return Collections.unmodifiableSet(this.queries);
    }

    public Set<String> getRescorerUsage() {
        return Collections.unmodifiableSet(this.rescorers);
    }

    public Set<String> getSectionsUsage() {
        return Collections.unmodifiableSet(this.sections);
    }

    public Set<String> getRetrieverUsage() {
        return Collections.unmodifiableSet(this.retrievers);
    }

    public Map<String, Map<String, Set<String>>> getExtendedDataUsage() {
        return this.extendedUsage.getUsage();
    }

    private static final class ExtendedUsageTracker {
        private final Map<String, Map<String, Set<String>>> categoriesToExtendedUsage = new HashMap<String, Map<String, Set<String>>>();

        private ExtendedUsageTracker() {
        }

        public void initialize(String category, String name) {
            this.categoriesToExtendedUsage.computeIfAbsent(category, k -> new HashMap()).computeIfAbsent(name, k -> new HashSet());
        }

        public void track(String category, String name, String value) {
            this.categoriesToExtendedUsage.computeIfAbsent(category, k -> new HashMap()).computeIfAbsent(name, k -> new HashSet()).add(value);
        }

        public void track(String category, String name, Set<String> values) {
            this.categoriesToExtendedUsage.computeIfAbsent(category, k -> new HashMap()).computeIfAbsent(name, k -> new HashSet()).addAll(values);
        }

        public Map<String, Map<String, Set<String>>> getUsage() {
            return Collections.unmodifiableMap(this.categoriesToExtendedUsage);
        }
    }
}

