/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.index.mapper.InferenceMetadataFieldsMapper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;

public final class FetchSourcePhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(final FetchContext fetchContext) {
        FetchSourceContext fetchSourceContext = fetchContext.fetchSourceContext();
        if (fetchSourceContext == null || !fetchSourceContext.fetchSource()) {
            return null;
        }
        assert (fetchSourceContext.fetchSource());
        final SourceFilter sourceFilter = fetchSourceContext.filter();
        final boolean filterExcludesAll = sourceFilter != null && sourceFilter.excludesAll();
        return new FetchSubPhaseProcessor(){
            private int fastPath;

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NEEDS_SOURCE;
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) {
                String index = fetchContext.getIndexName();
                if (!fetchContext.getSearchExecutionContext().isSourceEnabled()) {
                    if (sourceFilter != null) {
                        throw new IllegalArgumentException("unable to fetch fields from _source field: _source is disabled in the mappings for index [" + index + "]");
                    }
                    return;
                }
                this.hitExecute(hitContext);
            }

            private void hitExecute(FetchSubPhase.HitContext hitContext) {
                boolean nestedHit = hitContext.hit().getNestedIdentity() != null;
                Source source = hitContext.source();
                if (!nestedHit && sourceFilter == null) {
                    source = this.replaceInferenceMetadataFields(hitContext.hit(), source);
                    hitContext.hit().sourceRef(source.internalSourceRef());
                    ++this.fastPath;
                    return;
                }
                source = filterExcludesAll ? Source.empty(source.sourceContentType()) : (sourceFilter != null ? source.filter(sourceFilter) : source);
                source = nestedHit ? FetchSourcePhase.extractNested(source, hitContext.hit().getNestedIdentity()) : this.replaceInferenceMetadataFields(hitContext.hit(), source);
                hitContext.hit().sourceRef(source.internalSourceRef());
            }

            private Source replaceInferenceMetadataFields(SearchHit hit, Source source) {
                if (!InferenceMetadataFieldsMapper.isEnabled(fetchContext.getSearchExecutionContext().getMappingLookup())) {
                    return source;
                }
                DocumentField field = hit.removeDocumentField("_inference_fields");
                if (field == null || field.getValues().isEmpty()) {
                    return source;
                }
                Map<String, Object> newSource = source.source();
                if (!(newSource instanceof HashMap)) {
                    newSource = new HashMap<String, Object>(newSource);
                }
                newSource.put("_inference_fields", field.getValues().get(0));
                return Source.fromMap(newSource, source.sourceContentType());
            }

            @Override
            public Map<String, Object> getDebugInfo() {
                return Map.of("fast_path", this.fastPath);
            }
        };
    }

    private static Source extractNested(Source in, SearchHit.NestedIdentity nestedIdentity) {
        Map sourceMap = in.source();
        while (nestedIdentity != null) {
            if ((sourceMap = (Map)sourceMap.get(nestedIdentity.getField().string())) == null) {
                return Source.empty(in.sourceContentType());
            }
            nestedIdentity = nestedIdentity.getChild();
        }
        return Source.fromMap(sourceMap, in.sourceContentType());
    }
}

