/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.script.TimeSeries;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record ScriptContextStats(String context, long compilations, TimeSeries compilationsHistory, long cacheEvictions, TimeSeries cacheEvictionsHistory, long compilationLimitTriggered) implements Writeable,
ToXContentFragment,
Comparable<ScriptContextStats>
{
    public ScriptContextStats(String context, long compilationLimitTriggered, TimeSeries compilationsHistory, TimeSeries cacheEvictionsHistory) {
        this(Objects.requireNonNull(context), compilationsHistory.total, compilationsHistory, cacheEvictionsHistory.total, cacheEvictionsHistory, compilationLimitTriggered);
    }

    public static ScriptContextStats read(StreamInput in) throws IOException {
        TimeSeries cacheEvictionsHistory;
        TimeSeries compilationsHistory;
        String context = in.readString();
        long compilations = in.readVLong();
        long cacheEvictions = in.readVLong();
        long compilationLimitTriggered = in.readVLong();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_1_0)) {
            compilationsHistory = new TimeSeries(in);
            cacheEvictionsHistory = new TimeSeries(in);
        } else if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
            compilationsHistory = new TimeSeries(in).withTotal(compilations);
            cacheEvictionsHistory = new TimeSeries(in).withTotal(cacheEvictions);
        } else {
            compilationsHistory = new TimeSeries(compilations);
            cacheEvictionsHistory = new TimeSeries(cacheEvictions);
        }
        return new ScriptContextStats(context, compilations, compilationsHistory, cacheEvictions, cacheEvictionsHistory, compilationLimitTriggered);
    }

    public static ScriptContextStats merge(ScriptContextStats first, ScriptContextStats second) {
        assert (first.context.equals(second.context)) : "To merge 2 ScriptContextStats both of them must have the same context.";
        return new ScriptContextStats(first.context, first.compilations + second.compilations, TimeSeries.merge(first.compilationsHistory, second.compilationsHistory), first.cacheEvictions + second.cacheEvictions, TimeSeries.merge(first.cacheEvictionsHistory, second.cacheEvictionsHistory), first.compilationLimitTriggered + second.compilationLimitTriggered);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.context);
        out.writeVLong(this.compilations);
        out.writeVLong(this.cacheEvictions);
        out.writeVLong(this.compilationLimitTriggered);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
            this.compilationsHistory.writeTo(out);
            this.cacheEvictionsHistory.writeTo(out);
        }
    }

    public String getContext() {
        return this.context;
    }

    public long getCompilations() {
        return this.compilations;
    }

    public TimeSeries getCompilationsHistory() {
        return this.compilationsHistory;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    public TimeSeries getCacheEvictionsHistory() {
        return this.cacheEvictionsHistory;
    }

    public long getCompilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("context", this.getContext());
        builder.field("compilations", this.getCompilations());
        TimeSeries series = this.getCompilationsHistory();
        if (series != null && !series.areTimingsEmpty()) {
            builder.startObject("compilations_history");
            series.toXContent(builder, params);
            builder.endObject();
        }
        builder.field("cache_evictions", this.getCacheEvictions());
        series = this.getCacheEvictionsHistory();
        if (series != null && !series.areTimingsEmpty()) {
            builder.startObject("cache_evictions_history");
            series.toXContent(builder, params);
            builder.endObject();
        }
        builder.field("compilation_limit_triggered", this.getCompilationLimitTriggered());
        builder.endObject();
        return builder;
    }

    @Override
    public int compareTo(ScriptContextStats o) {
        return this.context.compareTo(o.context);
    }

    static final class Fields {
        static final String CONTEXT = "context";
        static final String COMPILATIONS = "compilations";
        static final String COMPILATIONS_HISTORY = "compilations_history";
        static final String CACHE_EVICTIONS = "cache_evictions";
        static final String CACHE_EVICTIONS_HISTORY = "cache_evictions_history";
        static final String COMPILATION_LIMIT_TRIGGERED = "compilation_limit_triggered";
        static final String FIVE_MINUTES = "5m";
        static final String FIFTEEN_MINUTES = "15m";
        static final String TWENTY_FOUR_HOURS = "24h";

        Fields() {
        }
    }
}

