/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class GeometryFieldScript
extends AbstractFieldScript {
    public static final ScriptContext<Factory> CONTEXT = GeometryFieldScript.newContext("geometry_field", Factory.class);
    public static final Factory PARSE_FROM_SOURCE = new Factory(){

        @Override
        public LeafFactory newFactory(String field, Map<String, Object> params, SearchLookup lookup, OnScriptError onScriptError) {
            return ctx -> new GeometryFieldScript(this, field, params, lookup, OnScriptError.FAIL, ctx){

                @Override
                public void execute() {
                    this.emitFromSource();
                }
            };
        }

        @Override
        public boolean isResultDeterministic() {
            return true;
        }

        @Override
        public boolean isParsedFromSource() {
            return true;
        }
    };
    public static final String[] PARAMETERS = new String[0];
    private final List<Geometry> geometries = new ArrayList<Geometry>();
    private final GeometryParser geometryParser = new GeometryParser(Orientation.CCW.getAsBoolean(), false, true);

    public static Factory leafAdapter(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentFactory) {
        return (leafFieldName, params, searchLookup, onScriptError) -> {
            CompositeFieldScript.LeafFactory parentLeafFactory = (CompositeFieldScript.LeafFactory)parentFactory.apply(searchLookup);
            return ctx -> {
                final CompositeFieldScript compositeFieldScript = parentLeafFactory.newInstance(ctx);
                return new GeometryFieldScript(leafFieldName, params, searchLookup, onScriptError, ctx){

                    @Override
                    public void setDocument(int docId) {
                        compositeFieldScript.setDocument(docId);
                    }

                    @Override
                    public void execute() {
                        this.emitFromCompositeScript(compositeFieldScript);
                    }
                };
            };
        };
    }

    public GeometryFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, OnScriptError onScriptError, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx, onScriptError);
    }

    @Override
    protected void prepareExecute() {
        this.geometries.clear();
    }

    public final void runForDoc(int docId, Consumer<Geometry> consumer) {
        this.runForDoc(docId);
        consumer.accept(this.geometry());
    }

    public final Geometry geometry() {
        if (this.geometries.isEmpty()) {
            return null;
        }
        return this.geometries.size() == 1 ? this.geometries.get(0) : new GeometryCollection(this.geometries);
    }

    public final int count() {
        return this.geometries.isEmpty() ? 0 : 1;
    }

    @Override
    protected void emitFromObject(Object value) {
        this.geometries.add(this.geometryParser.parseGeometry(value));
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3, OnScriptError var4);
    }

    public static interface LeafFactory {
        public GeometryFieldScript newInstance(LeafReaderContext var1);
    }

    public static class Emit {
        private final GeometryFieldScript script;

        public Emit(GeometryFieldScript script) {
            this.script = script;
        }

        public void emit(Object object) {
            this.script.checkMaxSize(this.script.geometries.size());
            this.script.emitFromObject(object);
        }
    }
}

