/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class DocsStats
implements Writeable,
ToXContentFragment {
    public static final ConstructingObjectParser<DocsStats, Void> PARSER = new ConstructingObjectParser("doc_stats", true, args -> (DocsStats)args[0]);
    protected static final ConstructingObjectParser<DocsStats, Void> DOC_STATS_PARSER = new ConstructingObjectParser("doc_stats_fields", true, args -> new DocsStats((Long)args[0], (Long)args[1], (Long)args[2]));
    private long count = 0L;
    private long deleted = 0L;
    private long totalSizeInBytes = 0L;

    public DocsStats() {
    }

    public DocsStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.deleted = in.readVLong();
        this.totalSizeInBytes = in.readVLong();
    }

    public DocsStats(long count, long deleted, long totalSizeInBytes) {
        this.count = count;
        this.deleted = deleted;
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public void add(DocsStats other) {
        if (other == null) {
            return;
        }
        if (this.totalSizeInBytes == -1L) {
            this.totalSizeInBytes = other.totalSizeInBytes;
        } else if (other.totalSizeInBytes != -1L) {
            this.totalSizeInBytes += other.totalSizeInBytes;
        }
        this.count += other.count;
        this.deleted += other.deleted;
    }

    public long getCount() {
        return this.count;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeVLong(this.deleted);
        out.writeVLong(this.totalSizeInBytes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("docs");
        builder.field("count", this.count);
        builder.field("deleted", this.deleted);
        builder.humanReadableField("total_size_in_bytes", "total_size", (Object)ByteSizeValue.ofBytes(this.totalSizeInBytes));
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocsStats that = (DocsStats)o;
        return this.count == that.count && this.deleted == that.deleted && this.totalSizeInBytes == that.totalSizeInBytes;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.deleted, this.totalSizeInBytes);
    }

    public String toString() {
        return "DocStats{count=" + this.count + ", deleted=" + this.deleted + ", totalSizeInBytes=" + this.totalSizeInBytes + "}";
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), DOC_STATS_PARSER, new ParseField("docs", new String[0]));
        DOC_STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("count", new String[0]));
        DOC_STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("deleted", new String[0]));
        DOC_STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("total_size_in_bytes", new String[0]));
    }

    static final class Fields {
        static final String DOCS = "docs";
        static final String COUNT = "count";
        static final String DELETED = "deleted";
        static final String TOTAL_SIZE_IN_BYTES = "total_size_in_bytes";
        static final String TOTAL_SIZE = "total_size";

        Fields() {
        }
    }
}

