/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.support.MapXContentParser;

public abstract class AbstractGeometryFieldMapper<T>
extends FieldMapper {
    protected static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger("org.elasticsearch.index.mapper.GeoShapeFieldMapper");
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> ignoreZValue;
    private final Parser<T> parser;

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformedParam(Function<FieldMapper, Explicit<Boolean>> initializer, boolean ignoreMalformedByDefault) {
        return FieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, initializer, ignoreMalformedByDefault);
    }

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreZValueParam(Function<FieldMapper, Explicit<Boolean>> initializer) {
        return FieldMapper.Parameter.explicitBoolParam("ignore_z_value", true, initializer, true);
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, Parser<T> parser) {
        super(simpleName, mappedFieldType, builderParams);
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
        this.parser = parser;
    }

    @Override
    public AbstractGeometryFieldType<T> fieldType() {
        return (AbstractGeometryFieldType)this.mappedFieldType;
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected abstract void index(DocumentParserContext var1, T var2) throws IOException;

    @Override
    protected boolean supportsParsingObject() {
        return true;
    }

    @Override
    public final void parse(DocumentParserContext context) throws IOException {
        if (this.builderParams.hasScript()) {
            throw new DocumentParsingException(context.parser().getTokenLocation(), "failed to parse field [" + this.fieldType().name() + "] of type + " + this.contentType() + "]", new IllegalArgumentException("Cannot index data directly into a field with a [script] parameter"));
        }
        this.parser.parse(context.parser(), v -> this.index(context, v), new DefaultMalformedValueHandler((e, b) -> this.onMalformedValue(context, (XContentBuilder)b, (Exception)e)));
    }

    protected void onMalformedValue(DocumentParserContext context, XContentBuilder malformedDataForSyntheticSource, Exception cause) throws IOException {
        if (!this.ignoreMalformed()) {
            throw new DocumentParsingException(context.parser().getTokenLocation(), "failed to parse field [" + this.fieldType().name() + "] of type [" + this.contentType() + "]", cause);
        }
        context.addIgnoredField(this.fieldType().name());
    }

    @Override
    public boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    public boolean ignoreZValue() {
        return this.ignoreZValue.value();
    }

    @Override
    public final boolean parsesArrayValue() {
        return true;
    }

    public static abstract class Parser<T> {
        public abstract void parse(XContentParser var1, CheckedConsumer<T, IOException> var2, MalformedValueHandler var3) throws IOException;

        private void fetchFromSource(Object sourceMap, Consumer<T> consumer) {
            try (XContentParser parser = Parser.wrapObject(sourceMap);){
                this.parseFromSource(parser, consumer);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void parseFromSource(XContentParser parser, Consumer<T> consumer) throws IOException {
            this.parse(parser, v -> consumer.accept(this.normalizeFromSource(v)), NoopMalformedValueHandler.INSTANCE);
        }

        public abstract T normalizeFromSource(T var1);

        private static XContentParser wrapObject(Object sourceMap) throws IOException {
            MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, Collections.singletonMap("dummy_field", sourceMap), XContentType.JSON);
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            return parser;
        }
    }

    public static abstract class AbstractGeometryFieldType<T>
    extends MappedFieldType {
        protected final Parser<T> geometryParser;
        protected final T nullValue;

        protected AbstractGeometryFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Parser<T> geometryParser, T nullValue, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, meta);
            this.nullValue = nullValue;
            this.geometryParser = geometryParser;
        }

        @Override
        public final Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]");
        }

        protected abstract Function<List<T>, List<Object>> getFormatter(String var1);

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            final Function<List<T>, List<Object>> formatter = this.getFormatter(format != null ? format : "geojson");
            return new ArraySourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    ArrayList values = new ArrayList();
                    geometryParser.fetchFromSource(value, values::add);
                    return formatter.apply(values);
                }
            };
        }

        public ValueFetcher valueFetcher(Set<String> sourcePaths, T nullValue, String format) {
            final Function<List<T>, List<Object>> formatter = this.getFormatter(format != null ? format : "geojson");
            return new ArraySourceValueFetcher(sourcePaths, this.nullValueAsSource(nullValue)){

                @Override
                protected Object parseSourceValue(Object value) {
                    ArrayList values = new ArrayList();
                    geometryParser.fetchFromSource(value, values::add);
                    return formatter.apply(values);
                }
            };
        }

        protected BlockLoader blockLoaderFromSource(MappedFieldType.BlockLoaderContext blContext) {
            ValueFetcher fetcher = this.valueFetcher(blContext.sourcePaths(this.name()), this.nullValue, "wkb");
            return new BlockSourceReader.GeometriesBlockLoader(fetcher, BlockSourceReader.lookupMatchingAll());
        }

        protected abstract Object nullValueAsSource(T var1);

        protected BlockLoader blockLoaderFromFallbackSyntheticSource(MappedFieldType.BlockLoaderContext blContext) {
            return new FallbackSyntheticSourceBlockLoader(this, new GeometriesFallbackSyntheticSourceReader(), this.name(), IgnoredSourceFieldMapper.ignoredSourceFormat(blContext.indexSettings().getIndexVersionCreated())){

                @Override
                public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                    return factory.bytesRefs(expectedCount);
                }
            };
        }

        private class GeometriesFallbackSyntheticSourceReader
        implements FallbackSyntheticSourceBlockLoader.Reader<BytesRef> {
            private final Function<List<T>, List<Object>> formatter;

            private GeometriesFallbackSyntheticSourceReader() {
                this.formatter = AbstractGeometryFieldType.this.getFormatter("wkb");
            }

            @Override
            public void convertValue(Object value, List<BytesRef> accumulator) {
                ArrayList values = new ArrayList();
                AbstractGeometryFieldType.this.geometryParser.fetchFromSource(value, v -> {
                    if (v != null) {
                        values.add(v);
                    } else if (AbstractGeometryFieldType.this.nullValue != null) {
                        values.add(AbstractGeometryFieldType.this.nullValue);
                    }
                });
                List<Object> formatted = this.formatter.apply(values);
                for (Object formattedValue : formatted) {
                    if (formattedValue instanceof byte[]) {
                        byte[] wkb = (byte[])formattedValue;
                        accumulator.add(new BytesRef(wkb));
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported source type for spatial geometry: " + formattedValue.getClass().getSimpleName());
                }
            }

            @Override
            public void parse(XContentParser parser, List<BytesRef> accumulator) throws IOException {
                ArrayList values = new ArrayList();
                AbstractGeometryFieldType.this.geometryParser.parseFromSource(parser, v -> {
                    if (v != null) {
                        values.add(v);
                    } else if (AbstractGeometryFieldType.this.nullValue != null) {
                        values.add(AbstractGeometryFieldType.this.nullValue);
                    }
                });
                List<Object> formatted = this.formatter.apply(values);
                for (Object formattedValue : formatted) {
                    if (formattedValue instanceof byte[]) {
                        byte[] wkb = (byte[])formattedValue;
                        accumulator.add(new BytesRef(wkb));
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported source type for spatial geometry: " + formattedValue.getClass().getSimpleName());
                }
            }

            @Override
            public void writeToBlock(List<BytesRef> values, BlockLoader.Builder blockBuilder) {
                BlockLoader.BytesRefBuilder bytesRefBuilder = (BlockLoader.BytesRefBuilder)blockBuilder;
                for (BytesRef value : values) {
                    bytesRefBuilder.appendBytesRef(value);
                }
            }
        }
    }

    public record DefaultMalformedValueHandler(CheckedBiConsumer<Exception, XContentBuilder, IOException> consumer) implements MalformedValueHandler
    {
        @Override
        public void notify(Exception parsingException) throws IOException {
            this.consumer.accept(parsingException, null);
        }

        @Override
        public void notify(Exception parsingException, XContentBuilder malformedDataForSyntheticSource) throws IOException {
            this.consumer.accept(parsingException, malformedDataForSyntheticSource);
        }
    }

    public static interface MalformedValueHandler {
        public void notify(Exception var1) throws IOException;

        public void notify(Exception var1, XContentBuilder var2) throws IOException;
    }

    public record NoopMalformedValueHandler() implements MalformedValueHandler
    {
        public static final NoopMalformedValueHandler INSTANCE = new NoopMalformedValueHandler();

        @Override
        public void notify(Exception parsingException) {
        }

        @Override
        public void notify(Exception parsingException, XContentBuilder malformedDataForSyntheticSource) {
        }
    }
}

