/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.WrappedRunnable;

class TimedRunnable
extends AbstractRunnable
implements WrappedRunnable {
    private final Runnable original;
    private final long creationTimeNanos;
    private long beforeExecuteTime = -1L;
    private long startTimeNanos;
    private long finishTimeNanos = -1L;
    private boolean failedOrRejected = false;

    TimedRunnable(Runnable original) {
        this.original = original;
        this.creationTimeNanos = System.nanoTime();
    }

    @Override
    public void doRun() {
        try {
            this.startTimeNanos = System.nanoTime();
            this.original.run();
        }
        finally {
            this.finishTimeNanos = System.nanoTime();
        }
    }

    @Override
    public void onRejection(Exception e) {
        this.failedOrRejected = true;
        if (this.original instanceof AbstractRunnable) {
            ((AbstractRunnable)this.original).onRejection(e);
        } else {
            ExceptionsHelper.reThrowIfNotNull(e);
        }
    }

    @Override
    public void onFailure(Exception e) {
        this.failedOrRejected = true;
        ExceptionsHelper.reThrowIfNotNull(e);
    }

    @Override
    public boolean isForceExecution() {
        return this.original instanceof AbstractRunnable && ((AbstractRunnable)this.original).isForceExecution();
    }

    long getQueueTimeNanos() {
        if (this.beforeExecuteTime == -1L) {
            assert (false) : "beforeExecute must be called before getQueueTimeNanos";
            return -1L;
        }
        return this.beforeExecuteTime - this.creationTimeNanos;
    }

    long getTimeSinceCreationNanos() {
        return System.nanoTime() - this.creationTimeNanos;
    }

    long getTotalExecutionNanos() {
        if (this.startTimeNanos == -1L || this.finishTimeNanos == -1L) {
            return -1L;
        }
        return Math.max(this.finishTimeNanos - this.startTimeNanos, 1L);
    }

    public void beforeExecute() {
        this.beforeExecuteTime = System.nanoTime();
    }

    boolean getFailedOrRejected() {
        return this.failedOrRejected;
    }

    @Override
    public Runnable unwrap() {
        return this.original;
    }

    public String toString() {
        return "TimedRunnable{original=" + String.valueOf(this.original) + ", creationTimeNanos=" + this.creationTimeNanos + ", startTimeNanos=" + this.startTimeNanos + ", finishTimeNanos=" + this.finishTimeNanos + ", failedOrRejected=" + this.failedOrRejected + "}";
    }
}

