/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.AbstractScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;

public abstract class BaseSettingsUpdater {
    protected final AbstractScopedSettings scopedSettings;

    public BaseSettingsUpdater(AbstractScopedSettings scopedSettings) {
        this.scopedSettings = scopedSettings;
    }

    private static void logUnknownSetting(String settingType, Map.Entry<String, String> e, Logger logger) {
        logger.warn("ignoring existing unknown {} setting: [{}] with value [{}]; archiving", (Object)settingType, (Object)e.getKey(), (Object)e.getValue());
    }

    private static void logInvalidSetting(String settingType, Map.Entry<String, String> e, IllegalArgumentException ex, Logger logger) {
        logger.warn(() -> "ignoring existing invalid " + settingType + " setting: [" + (String)e.getKey() + "] with value [" + (String)e.getValue() + "]; archiving", (Throwable)ex);
    }

    protected final Tuple<Settings, Settings> partitionKnownAndValidSettings(Settings settings, String settingsType, Logger logger) {
        Settings existingArchivedSettings = settings.filter(k -> k.startsWith("archived."));
        Settings settingsExcludingExistingArchivedSettings = settings.filter(k -> !k.startsWith("archived."));
        Settings settingsWithUnknownOrInvalidArchived = this.scopedSettings.archiveUnknownOrInvalidSettings(settingsExcludingExistingArchivedSettings, e -> BaseSettingsUpdater.logUnknownSetting(settingsType, e, logger), (e, ex) -> BaseSettingsUpdater.logInvalidSetting(settingsType, e, ex, logger));
        return Tuple.tuple((Object)Settings.builder().put(settingsWithUnknownOrInvalidArchived.filter(k -> !k.startsWith("archived."))).put(existingArchivedSettings).build(), (Object)settingsWithUnknownOrInvalidArchived.filter(k -> k.startsWith("archived.")));
    }
}

