/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract sealed class IndexReshardingState
implements Writeable,
ToXContentFragment {
    public abstract int shardCountBefore();

    public abstract int shardCountAfter();

    public static final class Split
    extends IndexReshardingState {
        private static final ParseField SOURCE_SHARDS_FIELD = new ParseField("source_shards", new String[0]);
        private static final ParseField TARGET_SHARDS_FIELD = new ParseField("target_shards", new String[0]);
        private static final ConstructingObjectParser<Split, Void> SPLIT_PARSER = new ConstructingObjectParser("split", args -> new Split(((List)args[0]).toArray(new SourceShardState[0]), ((List)args[1]).toArray(new TargetShardState[0])));
        private final int oldShardCount;
        private final int newShardCount;
        private final SourceShardState[] sourceShards;
        private final TargetShardState[] targetShards;

        Split(SourceShardState[] sourceShards, TargetShardState[] targetShards) {
            assert (!Arrays.stream(sourceShards).allMatch(state -> state == SourceShardState.DONE));
            this.sourceShards = sourceShards;
            this.targetShards = targetShards;
            this.oldShardCount = sourceShards.length;
            this.newShardCount = this.oldShardCount + targetShards.length;
        }

        Split(StreamInput in) throws IOException {
            this(in.readArray(SourceShardState::readFrom, SourceShardState[]::new), in.readArray(TargetShardState::readFrom, TargetShardState[]::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeArray(this.sourceShards);
            out.writeArray(this.targetShards);
        }

        static Split fromXContent(XContentParser parser) throws IOException {
            return (Split)SPLIT_PARSER.parse(parser, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(SOURCE_SHARDS_FIELD.getPreferredName(), (Object)this.sourceShards);
            builder.field(TARGET_SHARDS_FIELD.getPreferredName(), (Object)this.targetShards);
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Split otherState = (Split)other;
            return Arrays.equals(this.sourceShards, otherState.sourceShards) && Arrays.equals(this.targetShards, otherState.targetShards);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.sourceShards), Arrays.hashCode(this.targetShards));
        }

        @Override
        public int shardCountBefore() {
            return this.oldShardCount;
        }

        @Override
        public int shardCountAfter() {
            return this.newShardCount;
        }

        SourceShardState[] sourceShards() {
            return (SourceShardState[])this.sourceShards.clone();
        }

        TargetShardState[] targetShards() {
            return (TargetShardState[])this.targetShards.clone();
        }

        public int sourceShard(int targetShard) {
            return targetShard % this.shardCountBefore();
        }

        public static Split newSplitByMultiple(int shardCount, int multiple) {
            assert (multiple > 1) : "multiple must be greater than 1";
            int newShardCount = shardCount * multiple;
            Object[] sourceShards = new SourceShardState[shardCount];
            Object[] targetShards = new TargetShardState[newShardCount - shardCount];
            Arrays.fill(sourceShards, SourceShardState.SOURCE);
            Arrays.fill(targetShards, TargetShardState.CLONE);
            return new Split((SourceShardState[])sourceShards, (TargetShardState[])targetShards);
        }

        public Builder builder() {
            return new Builder(this);
        }

        public SourceShardState getSourceShardState(int shardNum) {
            assert (shardNum >= 0 && shardNum < this.sourceShards.length) : "source shardNum is out of bounds";
            return this.sourceShards[shardNum];
        }

        public boolean isSourceShard(int shardId) {
            return shardId < this.shardCountBefore();
        }

        public boolean isTargetShard(int shardId) {
            return !this.isSourceShard(shardId);
        }

        public TargetShardState getTargetShardState(int shardNum) {
            int targetShardNum = shardNum - this.oldShardCount;
            assert (targetShardNum >= 0 && targetShardNum < this.targetShards.length) : "target shardNum is out of bounds";
            return this.targetShards[targetShardNum];
        }

        public boolean targetStateAtLeast(int shardNum, TargetShardState targetShardState) {
            return this.getTargetShardState(shardNum).ordinal() >= targetShardState.ordinal();
        }

        public boolean allTargetStatesAtLeast(int sourceShardId, TargetShardState targetShardState) {
            TargetShardState[] targets;
            for (TargetShardState state : targets = this.getTargetStatesFor(sourceShardId)) {
                if (state.ordinal() >= targetShardState.ordinal()) continue;
                return false;
            }
            return true;
        }

        public Stream<TargetShardState> targetStates() {
            return Arrays.stream(this.targetShards);
        }

        public Stream<SourceShardState> sourceStates() {
            return Arrays.stream(this.sourceShards);
        }

        public boolean targetsDone(int shardNum) {
            TargetShardState[] targets = this.getTargetStatesFor(shardNum);
            return Arrays.stream(targets).allMatch(target -> target == TargetShardState.DONE);
        }

        private TargetShardState[] getTargetStatesFor(int shardNum) {
            int numTargets = this.newShardCount / this.oldShardCount - 1;
            TargetShardState[] targets = new TargetShardState[numTargets];
            int cur = shardNum + this.oldShardCount;
            for (int i = 0; i < numTargets; ++i) {
                targets[i] = this.getTargetShardState(cur);
                cur += this.oldShardCount;
            }
            return targets;
        }

        static {
            SPLIT_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, c) -> SourceShardState.valueOf(parser.text()), SOURCE_SHARDS_FIELD);
            SPLIT_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, c) -> TargetShardState.valueOf(parser.text()), TARGET_SHARDS_FIELD);
        }

        public static enum SourceShardState implements Writeable
        {
            SOURCE(0),
            DONE(1);

            private final byte code;

            private SourceShardState(byte code) {
                this.code = code;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeByte(this.code);
            }

            public static SourceShardState readFrom(StreamInput in) throws IOException {
                byte code = in.readByte();
                return switch (code) {
                    case 0 -> SOURCE;
                    case 1 -> DONE;
                    default -> throw new IllegalStateException("unknown source shard state [" + code + "]");
                };
            }
        }

        public static enum TargetShardState implements Writeable
        {
            CLONE(0),
            HANDOFF(1),
            SPLIT(2),
            DONE(3);

            private final byte code;

            private TargetShardState(byte code) {
                this.code = code;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeByte(this.code);
            }

            public static TargetShardState readFrom(StreamInput in) throws IOException {
                byte code = in.readByte();
                return switch (code) {
                    case 0 -> CLONE;
                    case 1 -> HANDOFF;
                    case 2 -> SPLIT;
                    case 3 -> DONE;
                    default -> throw new IllegalStateException("unknown target shard state [" + code + "]");
                };
            }
        }

        public static class Builder {
            private final SourceShardState[] sourceShards;
            private final TargetShardState[] targetShards;

            public Builder(Split split) {
                this.sourceShards = split.sourceShards();
                this.targetShards = split.targetShards();
            }

            public void setSourceShardState(int shardNum, SourceShardState sourceShardState) {
                assert (shardNum >= 0 && shardNum < this.sourceShards.length) : "source shardNum is out of bounds";
                assert (this.sourceShards[shardNum].ordinal() + 1 == sourceShardState.ordinal()) : "invalid source shard state transition";
                assert (sourceShardState == SourceShardState.DONE) : "can only move source shard state to DONE";
                Split split = new Split(this.sourceShards, this.targetShards);
                for (TargetShardState target : split.getTargetStatesFor(shardNum)) {
                    assert (target == TargetShardState.DONE) : "can only move source shard to DONE when all targets are DONE";
                }
                this.sourceShards[shardNum] = sourceShardState;
            }

            public void setTargetShardState(int shardNum, TargetShardState targetShardState) {
                int targetShardNum = shardNum - this.sourceShards.length;
                assert (targetShardNum >= 0 && targetShardNum < this.targetShards.length) : "target shardNum is out of bounds";
                assert (this.targetShards[targetShardNum].ordinal() + 1 == targetShardState.ordinal()) : "invalid target shard state transition";
                this.targetShards[targetShardNum] = targetShardState;
            }

            public Split build() {
                return new Split(this.sourceShards, this.targetShards);
            }
        }
    }

    public static final class Noop
    extends IndexReshardingState {
        private static final ObjectParser<Noop, Void> NOOP_PARSER = new ObjectParser("noop", Noop::new);

        Noop() {
        }

        Noop(StreamInput in) throws IOException {
            this();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }

        static IndexReshardingState fromXContent(XContentParser parser) throws IOException {
            return (IndexReshardingState)NOOP_PARSER.parse(parser, null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other != null && this.getClass() == other.getClass();
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public int shardCountBefore() {
            return 1;
        }

        @Override
        public int shardCountAfter() {
            return 1;
        }
    }
}

