/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record NodeUsageStatsForThreadPools(String nodeId, Map<String, ThreadPoolUsageStats> threadPoolUsageStatsMap) implements Writeable
{
    public NodeUsageStatsForThreadPools(StreamInput in) throws IOException {
        this(in.readString(), in.readImmutableMap(ThreadPoolUsageStats::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeMap(this.threadPoolUsageStatsMap, StreamOutput::writeWriteable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nodeId, this.threadPoolUsageStatsMap);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeUsageStatsForThreadPools other = (NodeUsageStatsForThreadPools)o;
        for (Map.Entry<String, ThreadPoolUsageStats> entry : other.threadPoolUsageStatsMap.entrySet()) {
            if (!this.nodeId.equals(other.nodeId)) {
                return false;
            }
            ThreadPoolUsageStats loadStats = this.threadPoolUsageStatsMap.get(entry.getKey());
            if (loadStats != null && loadStats.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName() + "{nodeId=" + this.nodeId + ", threadPoolUsageStatsMap=[");
        for (Map.Entry<String, ThreadPoolUsageStats> entry : this.threadPoolUsageStatsMap.entrySet()) {
            builder.append("{ThreadPool.Names=" + entry.getKey() + ", ThreadPoolUsageStats=" + String.valueOf(entry.getValue()) + "}");
        }
        builder.append("]}");
        return builder.toString();
    }

    public record ThreadPoolUsageStats(int totalThreadPoolThreads, float averageThreadPoolUtilization, long maxThreadPoolQueueLatencyMillis) implements Writeable
    {
        public ThreadPoolUsageStats(StreamInput in) throws IOException {
            this(in.readVInt(), in.readFloat(), in.readVLong());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.totalThreadPoolThreads);
            out.writeFloat(this.averageThreadPoolUtilization);
            out.writeVLong(this.maxThreadPoolQueueLatencyMillis);
        }
    }
}

