/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ingest.WriteableIngestDocument;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SimulateProcessorResult
implements Writeable,
ToXContentObject {
    private static final String IGNORED_ERROR_FIELD = "ignored_error";
    private static final String STATUS_FIELD = "status";
    private static final String TYPE_FIELD = "processor_type";
    private static final String CONDITION_FIELD = "condition";
    private static final String RESULT_FIELD = "result";
    private final String type;
    private final String processorTag;
    private final String description;
    private final WriteableIngestDocument ingestDocument;
    private final Exception failure;
    private final Tuple<String, Boolean> conditionalWithResult;
    private static final ConstructingObjectParser<ElasticsearchException, Void> IGNORED_ERROR_PARSER = new ConstructingObjectParser("ignored_error_parser", true, a -> (ElasticsearchException)a[0]);
    private static final ConstructingObjectParser<Tuple<String, Boolean>, Void> IF_CONDITION_PARSER;
    public static final ConstructingObjectParser<SimulateProcessorResult, Void> PARSER;

    public SimulateProcessorResult(String type, String processorTag, String description, IngestDocument ingestDocument, Exception failure, Tuple<String, Boolean> conditionalWithResult) {
        this.processorTag = processorTag;
        this.description = description;
        WriteableIngestDocument wid = null;
        if (ingestDocument != null) {
            try {
                wid = new WriteableIngestDocument(ingestDocument);
            }
            catch (Exception ex) {
                if (failure != null) {
                    ex.addSuppressed(failure);
                }
                failure = ex;
            }
        }
        this.ingestDocument = wid;
        this.failure = failure;
        this.conditionalWithResult = conditionalWithResult;
        this.type = type;
    }

    public SimulateProcessorResult(String type, String processorTag, String description, IngestDocument ingestDocument, Tuple<String, Boolean> conditionalWithResult) {
        this(type, processorTag, description, ingestDocument, null, conditionalWithResult);
    }

    public SimulateProcessorResult(String type, String processorTag, String description, Exception failure, Tuple<String, Boolean> conditionalWithResult) {
        this(type, processorTag, description, null, failure, conditionalWithResult);
    }

    public SimulateProcessorResult(String type, String processorTag, String description, Tuple<String, Boolean> conditionalWithResult) {
        this(type, processorTag, description, null, null, conditionalWithResult);
    }

    SimulateProcessorResult(StreamInput in) throws IOException {
        this.processorTag = in.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0) ? in.readOptionalString() : in.readString();
        this.ingestDocument = in.readOptionalWriteable(WriteableIngestDocument::new);
        this.failure = in.readException();
        this.description = in.readOptionalString();
        this.type = in.readString();
        boolean hasConditional = in.readBoolean();
        this.conditionalWithResult = hasConditional ? new Tuple((Object)in.readString(), (Object)in.readBoolean()) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
            out.writeOptionalString(this.processorTag);
        } else {
            out.writeString(this.processorTag);
        }
        out.writeOptionalWriteable(this.ingestDocument);
        out.writeException(this.failure);
        out.writeOptionalString(this.description);
        out.writeString(this.type);
        out.writeBoolean(this.conditionalWithResult != null);
        if (this.conditionalWithResult != null) {
            out.writeString((String)this.conditionalWithResult.v1());
            out.writeBoolean((Boolean)this.conditionalWithResult.v2());
        }
    }

    public IngestDocument getIngestDocument() {
        if (this.ingestDocument == null) {
            return null;
        }
        return this.ingestDocument.getIngestDocument();
    }

    public String getProcessorTag() {
        return this.processorTag;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public String getDescription() {
        return this.description;
    }

    public Tuple<String, Boolean> getConditionalWithResult() {
        return this.conditionalWithResult;
    }

    public String getType() {
        return this.type;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.type != null) {
            builder.field(TYPE_FIELD, this.type);
        }
        builder.field(STATUS_FIELD, (Enum)this.getStatus(this.type));
        if (this.description != null) {
            builder.field("description", this.description);
        }
        if (this.processorTag != null) {
            builder.field("tag", this.processorTag);
        }
        if (this.conditionalWithResult != null) {
            builder.startObject("if");
            builder.field(CONDITION_FIELD, (String)this.conditionalWithResult.v1());
            builder.field(RESULT_FIELD, (Boolean)this.conditionalWithResult.v2());
            builder.endObject();
        }
        if (this.failure != null && this.ingestDocument != null) {
            builder.startObject(IGNORED_ERROR_FIELD);
            ElasticsearchException.generateFailureXContent(builder, params, this.failure, true);
            builder.endObject();
        } else if (this.failure != null) {
            ElasticsearchException.generateFailureXContent(builder, params, this.failure, true);
        }
        if (this.ingestDocument != null) {
            this.ingestDocument.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static SimulateProcessorResult fromXContent(XContentParser parser) {
        return (SimulateProcessorResult)PARSER.apply(parser, null);
    }

    Status getStatus(String type) {
        if (this.conditionalWithResult == null || this.conditionalWithResult != null && ((Boolean)this.conditionalWithResult.v2()).booleanValue()) {
            if (this.failure != null) {
                if (this.ingestDocument == null) {
                    return Status.ERROR;
                }
                return Status.ERROR_IGNORED;
            }
            if (this.ingestDocument == null && !"pipeline".equals(type)) {
                return Status.DROPPED;
            }
            return Status.SUCCESS;
        }
        return Status.SKIPPED;
    }

    public String toString() {
        return "SimulateProcessorResult{type='" + this.type + "', processorTag='" + this.processorTag + "', description='" + this.description + "', ingestDocument=" + String.valueOf(this.ingestDocument) + ", failure=" + String.valueOf(this.failure) + ", conditionalWithResult=" + String.valueOf(this.conditionalWithResult) + "}";
    }

    static {
        IGNORED_ERROR_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField("error", new String[0]));
        IF_CONDITION_PARSER = new ConstructingObjectParser("if_condition_parser", true, a -> {
            String condition = a[0] == null ? null : (String)a[0];
            Boolean result = a[1] == null ? null : (Boolean)a[1];
            return new Tuple((Object)condition, (Object)result);
        });
        IF_CONDITION_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(CONDITION_FIELD, new String[0]));
        IF_CONDITION_PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField(RESULT_FIELD, new String[0]));
        PARSER = new ConstructingObjectParser("simulate_processor_result", true, a -> {
            String type = (String)a[0];
            String processorTag = a[1] == null ? null : (String)a[1];
            String description = a[2] == null ? null : (String)a[2];
            Tuple conditionalWithResult = a[3] == null ? null : (Tuple)a[3];
            IngestDocument document = a[4] == null ? null : ((WriteableIngestDocument)a[4]).getIngestDocument();
            ElasticsearchException failure = null;
            if (a[5] != null) {
                failure = (ElasticsearchException)a[5];
            } else if (a[6] != null) {
                failure = (ElasticsearchException)a[6];
            }
            return new SimulateProcessorResult(type, processorTag, description, document, failure, (Tuple<String, Boolean>)conditionalWithResult);
        });
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TYPE_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("tag", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("description", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), IF_CONDITION_PARSER, new ParseField("if", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), WriteableIngestDocument.INGEST_DOC_PARSER, new ParseField("doc", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), IGNORED_ERROR_PARSER, new ParseField(IGNORED_ERROR_FIELD, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField("error", new String[0]));
    }

    static enum Status {
        SUCCESS,
        ERROR,
        ERROR_IGNORED,
        SKIPPED,
        DROPPED;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Status fromString(String string) {
            return Status.valueOf(string.toUpperCase(Locale.ROOT));
        }
    }
}

