/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.client.internal.Requests;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class IndexSource
implements Writeable,
Releasable {
    private XContentType contentType;
    private BytesReference source;
    private boolean isClosed = false;

    public IndexSource() {
    }

    public IndexSource(XContentType contentType, BytesReference source) {
        this.contentType = contentType;
        this.source = ReleasableBytesReference.wrap(source);
    }

    public IndexSource(StreamInput in) throws IOException {
        this.contentType = in.readBoolean() ? XContentType.ofOrdinal((int)in.readByte()) : null;
        this.source = ReleasableBytesReference.wrap(in.readBytesReference());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (!this.isClosed);
        if (this.contentType != null) {
            out.writeBoolean(true);
            XContentHelper.writeTo(out, this.contentType);
        } else {
            out.writeBoolean(false);
        }
        out.writeBytesReference(this.source);
    }

    public XContentType contentType() {
        assert (!this.isClosed);
        return this.contentType;
    }

    public BytesReference bytes() {
        assert (!this.isClosed);
        return this.source;
    }

    public boolean hasSource() {
        assert (!this.isClosed);
        return this.source != null;
    }

    public int byteLength() {
        assert (!this.isClosed);
        return this.source == null ? 0 : this.source.length();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() {
        assert (!this.isClosed);
        this.isClosed = true;
        this.source = null;
        this.contentType = null;
    }

    public Map<String, Object> sourceAsMap() {
        assert (!this.isClosed);
        return (Map)XContentHelper.convertToMap(this.source, false, this.contentType).v2();
    }

    public void source(Map<String, ?> source) throws ElasticsearchGenerationException {
        this.source(source, Requests.INDEX_CONTENT_TYPE);
    }

    public void source(Map<String, ?> source, XContentType contentType) throws ElasticsearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)contentType);
            builder.map(source);
            this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
    }

    public void source(Map<String, ?> source, XContentType contentType, boolean ensureNoSelfReferences) throws ElasticsearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)contentType);
            builder.map(source, ensureNoSelfReferences);
            this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
    }

    public void source(String source, XContentType xContentType) {
        this.source(new BytesArray(source), xContentType);
    }

    public void source(XContentBuilder sourceBuilder) {
        this.source(BytesReference.bytes(sourceBuilder), sourceBuilder.contentType());
    }

    public void source(Object ... source) {
        this.source(Requests.INDEX_CONTENT_TYPE, source);
    }

    public void source(XContentType xContentType, Object ... source) {
        this.source(IndexSource.getXContentBuilder(xContentType, source));
    }

    public static XContentBuilder getXContentBuilder(XContentType xContentType, Object ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("The number of object passed must be even but was [" + source.length + "]");
        }
        if (source.length == 2 && source[0] instanceof BytesReference && source[1] instanceof Boolean) {
            throw new IllegalArgumentException("you are using the removed method for source with bytes and unsafe flag, the unsafe flag was removed, please just use source(BytesReference)");
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);
            builder.startObject();
            for (int i = 0; i < source.length; i += 2) {
                String field = source[i].toString();
                Object value = source[i + 1];
                builder.field(field, value);
            }
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    public void source(ReleasableBytesReference source, XContentType contentType) {
        this.setSource(source, contentType);
    }

    public void source(BytesReference source, XContentType contentType) {
        this.setSource(source, contentType);
    }

    public void source(byte[] source, XContentType contentType) {
        this.source(source, 0, source.length, contentType);
    }

    public void source(byte[] source, int offset, int length, XContentType contentType) {
        this.source(new BytesArray(source, offset, length), contentType);
    }

    private void setSource(BytesReference source, XContentType contentType) {
        assert (!this.isClosed);
        this.source = source;
        this.contentType = contentType;
    }
}

