/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.usage;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.NodeUsageStatsForThreadPools;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.AbstractTransportRequest;

public class NodeUsageStatsForThreadPoolsAction {

    public static class NodeResponse
    extends BaseNodeResponse {
        private final NodeUsageStatsForThreadPools nodeUsageStatsForThreadPools;

        protected NodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
            super(in, node);
            this.nodeUsageStatsForThreadPools = new NodeUsageStatsForThreadPools(in);
        }

        public NodeResponse(DiscoveryNode node, NodeUsageStatsForThreadPools nodeUsageStatsForThreadPools) {
            super(node);
            this.nodeUsageStatsForThreadPools = nodeUsageStatsForThreadPools;
        }

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.nodeUsageStatsForThreadPools = new NodeUsageStatsForThreadPools(in);
        }

        public NodeUsageStatsForThreadPools getNodeUsageStatsForThreadPools() {
            return this.nodeUsageStatsForThreadPools;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.nodeUsageStatsForThreadPools.writeTo(out);
        }

        public String toString() {
            return "NodeUsageStatsForThreadPoolsAction.NodeResponse{nodeId=" + this.getNode().getId() + ", nodeUsageStatsForThreadPools=" + String.valueOf(this.nodeUsageStatsForThreadPools) + "}";
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse> {
        protected Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodeResponses, List<FailedNodeException> nodeFailures) {
            super(clusterName, nodeResponses, nodeFailures);
        }

        public Map<String, NodeUsageStatsForThreadPools> getAllNodeUsageStatsForThreadPools() {
            HashMap<String, NodeUsageStatsForThreadPools> allNodeUsageStatsForThreadPools = new HashMap<String, NodeUsageStatsForThreadPools>();
            for (NodeResponse nodeResponse : this.getNodes()) {
                allNodeUsageStatsForThreadPools.put(nodeResponse.getNodeUsageStatsForThreadPools().nodeId(), nodeResponse.getNodeUsageStatsForThreadPools());
            }
            return allNodeUsageStatsForThreadPools;
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodeResponses) throws IOException {
            out.writeCollection(nodeResponses);
        }

        @Override
        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        public String toString() {
            return "NodeUsageStatsForThreadPoolsAction.Response{" + String.valueOf(this.getNodes()) + "}";
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeRequest() {
        }
    }

    public static class Request
    extends BaseNodesRequest {
        public Request(String[] nodeIds) {
            super(nodeIds);
        }
    }
}

