/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;

public interface SupportedVersion {
    public static final SupportedVersion SUPPORTED_ON_ALL_NODES = new SupportedVersion(){

        @Override
        public boolean supportedOn(TransportVersion version, boolean currentBuildIsSnapshot) {
            return true;
        }

        public String toString() {
            return "SupportedOnAllVersions";
        }
    };
    public static final SupportedVersion UNDER_CONSTRUCTION = new SupportedVersion(){

        @Override
        public boolean supportedOn(TransportVersion version, boolean currentBuildIsSnapshot) {
            return currentBuildIsSnapshot;
        }

        public String toString() {
            return "UnderConstruction";
        }
    };

    public boolean supportedOn(TransportVersion var1, boolean var2);

    default public boolean supportedLocally() {
        return this.supportedOn(TransportVersion.current(), Build.current().isSnapshot());
    }

    public static SupportedVersion supportedSince(final TransportVersion supportedVersion) {
        return new SupportedVersion(){

            @Override
            public boolean supportedOn(TransportVersion version, boolean currentBuildIsSnapshot) {
                return version.supports(supportedVersion) || currentBuildIsSnapshot;
            }

            public String toString() {
                return "SupportedOn[" + String.valueOf(supportedVersion) + "]";
            }
        };
    }
}

