/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.stream.Streams;
import org.gradle.api.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MockApmServer {
    private static final org.gradle.api.logging.Logger logger = Logging.getLogger(MockApmServer.class);
    private static final Logger log = LoggerFactory.getLogger(MockApmServer.class);
    private final Pattern metricFilter;
    private final Pattern transactionFilter;
    private final Pattern transactionExcludesFilter;
    private HttpServer instance;

    public MockApmServer(String metricFilter, String transactionFilter, String transactionExcludesFilter) {
        this.metricFilter = this.createWildcardPattern(metricFilter);
        this.transactionFilter = this.createWildcardPattern(transactionFilter);
        this.transactionExcludesFilter = this.createWildcardPattern(transactionExcludesFilter);
    }

    private Pattern createWildcardPattern(String filter) {
        if (filter == null || filter.isEmpty()) {
            return null;
        }
        String pattern = Arrays.stream(filter.split(",\\s*")).map(Pattern::quote).map(s -> s.replace("*", "\\E.*\\Q")).collect(Collectors.joining(")|(", "(", ")"));
        return Pattern.compile(pattern);
    }

    public void start() throws IOException {
        if (this.instance != null) {
            throw new IllegalStateException("MockApmServer already started");
        }
        InetSocketAddress addr = new InetSocketAddress("0.0.0.0", 0);
        HttpServer server = HttpServer.create(addr, 10);
        server.createContext("/", new RootHandler());
        server.start();
        this.instance = server;
        logger.lifecycle("MockApmServer started on port " + server.getAddress().getPort());
    }

    public int getPort() {
        if (this.instance == null) {
            throw new IllegalStateException("MockApmServer not started");
        }
        return this.instance.getAddress().getPort();
    }

    public void stop() {
        if (this.instance != null) {
            logger.lifecycle("stopping apm server");
            this.instance.stop(1);
            this.instance = null;
        }
    }

    class RootHandler
    implements HttpHandler {
        RootHandler() {
        }

        @Override
        public void handle(HttpExchange t) {
            try {
                InputStream body = t.getRequestBody();
                if (MockApmServer.this.metricFilter == null && MockApmServer.this.transactionFilter == null) {
                    this.logRequestBody(body);
                } else {
                    this.logFiltered(body);
                }
                String response = "{}";
                t.sendResponseHeaders(200, response.length());
                try (OutputStream os = t.getResponseBody();){
                    os.write(response.getBytes());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void logRequestBody(InputStream body) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)body, (OutputStream)bytes);
            logger.lifecycle("MockApmServer reading JSON objects: " + bytes.toString());
        }

        private void logFiltered(InputStream body) throws IOException {
            ObjectMapper mapper = new ObjectMapper();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(body));){
                String line;
                String tier = null;
                String node = null;
                while ((line = reader.readLine()) != null) {
                    JsonNode jsonNode = mapper.readTree(line);
                    if (jsonNode.has("metadata")) {
                        node = jsonNode.path("metadata").path("service").path("node").path("configured_name").asText(null);
                        tier = jsonNode.path("metadata").path("labels").path("node_tier").asText(null);
                        continue;
                    }
                    if (MockApmServer.this.transactionFilter != null && jsonNode.has("transaction")) {
                        JsonNode transaction = jsonNode.get("transaction");
                        String name = transaction.get("name").asText();
                        if (!MockApmServer.this.transactionFilter.matcher(name).matches() || MockApmServer.this.transactionExcludesFilter != null && MockApmServer.this.transactionExcludesFilter.matcher(name).matches()) continue;
                        logger.lifecycle("Transaction [{}/{}]: {}", new Object[]{node, tier, transaction});
                        continue;
                    }
                    if (MockApmServer.this.metricFilter == null || !jsonNode.has("metricset")) continue;
                    JsonNode metricset = jsonNode.get("metricset");
                    ObjectNode samples = (ObjectNode)metricset.get("samples");
                    for (String name : Streams.of((Iterator)samples.fieldNames()).toList()) {
                        if (MockApmServer.this.metricFilter.matcher(name).matches()) continue;
                        samples.remove(name);
                    }
                    if (samples.isEmpty()) continue;
                    logger.lifecycle("Metricset [{}/{}]", new Object[]{node, tier, metricset});
                }
            }
        }
    }
}

