/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.plugin.BasePluginBuildPlugin;
import org.elasticsearch.gradle.plugin.GenerateNamedComponentsTask;
import org.elasticsearch.gradle.plugin.GeneratePluginPropertiesTask;
import org.elasticsearch.gradle.plugin.PluginPropertiesExtension;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

public class StablePluginBuildPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(BasePluginBuildPlugin.class);
        project.getTasks().withType(GeneratePluginPropertiesTask.class).named("pluginProperties").configure(task -> {
            task.getIsStable().set((Object)true);
            Provider file = project.getLayout().getBuildDirectory().file("generated-descriptor/stable-plugin-descriptor.properties");
            task.getOutputFile().set(file);
        });
        TaskProvider pluginNamedComponents = project.getTasks().register("pluginNamedComponents", GenerateNamedComponentsTask.class, t -> {
            SourceSet mainSourceSet = (SourceSet)GradleUtils.getJavaSourceSets(project).findByName("main");
            Configuration dependencyJars = project.getConfigurations().getByName("compileClasspath");
            FileCollection compiledPluginClasses = mainSourceSet.getOutput().getClassesDirs();
            FileCollection classPath = dependencyJars.plus(compiledPluginClasses);
            t.setClasspath(classPath);
        });
        Configuration pluginScannerConfig = (Configuration)project.getConfigurations().create("pluginScannerConfig");
        DependencyHandler dependencyHandler = project.getDependencies();
        pluginScannerConfig.defaultDependencies(deps -> deps.add((Object)dependencyHandler.create((Object)("org.elasticsearch:elasticsearch-plugin-scanner:" + VersionProperties.getElasticsearch()))));
        pluginNamedComponents.configure(t -> t.setPluginScannerClasspath((FileCollection)pluginScannerConfig));
        PluginPropertiesExtension pluginExtension = (PluginPropertiesExtension)project.getExtensions().getByType(PluginPropertiesExtension.class);
        pluginExtension.getBundleSpec().from(new Object[]{pluginNamedComponents});
    }
}

