/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import java.io.File;
import java.io.OutputStream;
import javax.inject.Inject;
import org.elasticsearch.gradle.LoggedExec;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.gradle.workers.WorkerExecutor;

public abstract class GenerateNamedComponentsTask
extends DefaultTask {
    private static final Logger LOGGER = Logging.getLogger(GenerateNamedComponentsTask.class);
    private static final String NAMED_COMPONENTS_DIR = "generated-named-components/";
    private static final String NAMED_COMPONENTS_FILE = "named_components.json";
    private static final String NAMED_COMPONENTS_PATH = "generated-named-components/named_components.json";
    private final WorkerExecutor workerExecutor;
    private FileCollection pluginScannerClasspath;
    private FileCollection classpath;
    private ExecOperations execOperations;
    private ProjectLayout projectLayout;

    @Inject
    public GenerateNamedComponentsTask(WorkerExecutor workerExecutor, ExecOperations execOperations, ProjectLayout projectLayout) {
        this.workerExecutor = workerExecutor;
        this.execOperations = execOperations;
        this.projectLayout = projectLayout;
        this.getOutputFile().convention(projectLayout.getBuildDirectory().file(NAMED_COMPONENTS_PATH));
    }

    @TaskAction
    public void scanPluginClasses() {
        File outputFile = ((RegularFile)this.projectLayout.getBuildDirectory().file(NAMED_COMPONENTS_PATH).get()).getAsFile();
        ExecResult execResult = LoggedExec.javaexec(this.execOperations, (Action<JavaExecSpec>)((Action)spec -> {
            spec.classpath(new Object[]{this.pluginScannerClasspath.plus(this.getClasspath()).getAsPath()});
            spec.getMainClass().set((Object)"org.elasticsearch.plugin.scanner.NamedComponentScanner");
            spec.args(new Object[]{outputFile});
            spec.setErrorOutput((OutputStream)System.err);
            spec.setStandardOutput((OutputStream)System.out);
        }));
        execResult.assertNormalExitValue();
    }

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @CompileClasspath
    public FileCollection getClasspath() {
        return this.classpath.filter(File::exists);
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public void setPluginScannerClasspath(FileCollection pluginScannerClasspath) {
        this.pluginScannerClasspath = pluginScannerClasspath;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getPluginScannerClasspath() {
        return this.pluginScannerClasspath;
    }
}

