/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.CustomAuthenticator;
import org.elasticsearch.xpack.security.authc.Authenticator;

public class PluggableAuthenticatorChain
implements Authenticator {
    private static final Logger logger = LogManager.getLogger(PluggableAuthenticatorChain.class);
    private final List<CustomAuthenticator> customAuthenticators;

    public PluggableAuthenticatorChain(List<CustomAuthenticator> customAuthenticators) {
        this.customAuthenticators = Collections.unmodifiableList(customAuthenticators);
    }

    @Override
    public String name() {
        return "pluggable custom authenticator chain";
    }

    public List<CustomAuthenticator> getCustomAuthenticators() {
        return this.customAuthenticators;
    }

    public boolean hasCustomAuthenticators() {
        return this.customAuthenticators.size() > 0;
    }

    @Override
    public AuthenticationToken extractCredentials(Authenticator.Context context) {
        if (!this.hasCustomAuthenticators()) {
            return null;
        }
        for (CustomAuthenticator customAuthenticator : this.customAuthenticators) {
            AuthenticationToken token = customAuthenticator.extractToken(context.getThreadContext());
            if (token == null) continue;
            return token;
        }
        return null;
    }

    @Override
    public void authenticate(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        if (!this.hasCustomAuthenticators()) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
            return;
        }
        AuthenticationToken token = context.getMostRecentAuthenticationToken();
        if (token != null) {
            IteratingActionListener iteratingListener = new IteratingActionListener(listener, this.getAuthConsumer(context), this.customAuthenticators, context.getThreadContext(), Function.identity(), result -> result.getStatus() == AuthenticationResult.Status.CONTINUE);
            try {
                iteratingListener.run();
            }
            catch (Exception e) {
                logger.debug(() -> Strings.format((String)"Authentication of token [%s] failed", (Object[])new Object[]{token.getClass().getName()}), (Throwable)e);
                listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest(e, token)));
            }
            return;
        }
        listener.onResponse((Object)AuthenticationResult.notHandled());
    }

    private BiConsumer<CustomAuthenticator, ActionListener<AuthenticationResult<Authentication>>> getAuthConsumer(Authenticator.Context context) {
        AuthenticationToken token = context.getMostRecentAuthenticationToken();
        return (authenticator, iteratingListener) -> {
            if (authenticator.supports(token)) {
                authenticator.authenticate(token, ActionListener.wrap(response -> {
                    if (response.isAuthenticated()) {
                        iteratingListener.onResponse(response);
                    } else if (response.getStatus() == AuthenticationResult.Status.TERMINATE) {
                        Exception ex = response.getException();
                        if (ex == null) {
                            iteratingListener.onFailure((Exception)((Object)context.getRequest().authenticationFailed(token)));
                        } else {
                            iteratingListener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest(ex, token)));
                        }
                    } else if (response.getStatus() == AuthenticationResult.Status.CONTINUE) {
                        iteratingListener.onResponse((Object)AuthenticationResult.notHandled());
                    }
                }, ex -> iteratingListener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest((Exception)ex, token)))));
            } else {
                iteratingListener.onResponse((Object)AuthenticationResult.notHandled());
            }
        };
    }
}

