/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentString;

public final class Text
implements XContentString,
Comparable<Text>,
ToXContentFragment {
    public static final Text[] EMPTY_ARRAY = new Text[0];
    private XContentString.UTF8Bytes bytes;
    private String string;
    private int hash;
    private int stringLength = -1;

    public static Text[] convertFromStringArray(String[] strings) {
        if (strings.length == 0) {
            return EMPTY_ARRAY;
        }
        Text[] texts = new Text[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            texts[i] = new Text(strings[i]);
        }
        return texts;
    }

    public Text(XContentString.UTF8Bytes bytes) {
        this.bytes = bytes;
    }

    public Text(XContentString.UTF8Bytes bytes, int stringLength) {
        this.bytes = bytes;
        this.stringLength = stringLength;
    }

    public Text(String string) {
        this.string = string;
    }

    public boolean hasBytes() {
        return this.bytes != null;
    }

    @Override
    public XContentString.UTF8Bytes bytes() {
        if (this.bytes == null) {
            ByteBuffer byteBuff = StandardCharsets.UTF_8.encode(this.string);
            assert (byteBuff.hasArray());
            this.bytes = new XContentString.UTF8Bytes(byteBuff.array(), byteBuff.arrayOffset() + byteBuff.position(), byteBuff.remaining());
        }
        return this.bytes;
    }

    public boolean hasString() {
        return this.string != null;
    }

    @Override
    public String string() {
        if (this.string == null) {
            ByteBuffer byteBuff = ByteBuffer.wrap(this.bytes.bytes(), this.bytes.offset(), this.bytes.length());
            this.string = StandardCharsets.UTF_8.decode(byteBuff).toString();
            assert (this.stringLength < 0 || this.string.length() == this.stringLength);
        }
        return this.string;
    }

    @Override
    public int stringLength() {
        if (this.stringLength < 0) {
            if (this.hasString()) {
                this.stringLength = this.string().length();
            } else {
                this.stringLength = this.countCharsUtf8(this.bytes());
                if (this.stringLength < 0) {
                    this.stringLength = this.string().length();
                }
            }
        }
        return this.stringLength;
    }

    private int countCharsUtf8(XContentString.UTF8Bytes bytes) {
        int count = 0;
        int offset = bytes.offset();
        int end = offset + bytes.length();
        for (int i = offset; i < end; ++i) {
            byte b = bytes.bytes()[i];
            if ((b & 0x80) == 0) {
                ++count;
                continue;
            }
            if ((b & 0xE0) == 192) {
                ++count;
                ++i;
                continue;
            }
            if ((b & 0xF0) == 224) {
                ++count;
                i += 2;
                continue;
            }
            if ((b & 0xF8) == 240) {
                count += 2;
                i += 3;
                continue;
            }
            return -1;
        }
        return count;
    }

    public String toString() {
        return this.string();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.bytes().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.bytes().equals(((Text)obj).bytes());
    }

    @Override
    public int compareTo(Text text) {
        return this.bytes().compareTo(text.bytes());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.hasString()) {
            return builder.value(this.string());
        }
        return builder.utf8Value(this.bytes.bytes(), this.bytes.offset(), this.bytes.length());
    }
}

