/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ccr.ShardFollowNodeTaskStatus;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;

final class WaitForFollowShardTasksStep
extends AsyncWaitStep {
    static final String NAME = "wait-for-follow-shard-tasks";

    WaitForFollowShardTasksStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void evaluateCondition(ProjectState state, IndexMetadata indexMetadata, AsyncWaitStep.Listener listener, TimeValue masterTimeout) {
        Map customIndexMetadata = indexMetadata.getCustomData("ccr");
        if (customIndexMetadata == null) {
            listener.onResponse(true, null);
            return;
        }
        FollowStatsAction.StatsRequest request = new FollowStatsAction.StatsRequest();
        request.setIndices(new String[]{indexMetadata.getIndex().getName()});
        this.getClient(state.projectId()).execute((ActionType)FollowStatsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> WaitForFollowShardTasksStep.handleResponse(r, listener), listener::onFailure));
    }

    static void handleResponse(FollowStatsAction.StatsResponses responses, AsyncWaitStep.Listener listener) {
        boolean conditionMet;
        List<ShardFollowNodeTaskStatus> unSyncedShardFollowStatuses = responses.getStatsResponses().stream().map(FollowStatsAction.StatsResponse::status).filter(shardFollowStatus -> shardFollowStatus.leaderGlobalCheckpoint() != shardFollowStatus.followerGlobalCheckpoint()).toList();
        boolean bl = conditionMet = responses.getStatsResponses().size() > 0 && unSyncedShardFollowStatuses.isEmpty();
        if (conditionMet) {
            listener.onResponse(true, null);
        } else {
            List<ShardFollowTaskInfo> shardFollowTaskInfos = unSyncedShardFollowStatuses.stream().map(status -> new ShardFollowTaskInfo(status.followerIndex(), status.getShardId(), status.leaderGlobalCheckpoint(), status.followerGlobalCheckpoint())).toList();
            listener.onResponse(false, new Info(shardFollowTaskInfos));
        }
    }

    record Info(List<ShardFollowTaskInfo> shardFollowTaskInfos) implements ToXContentObject
    {
        static final ParseField SHARD_FOLLOW_TASKS = new ParseField("shard_follow_tasks", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.xContentList(SHARD_FOLLOW_TASKS.getPreferredName(), this.shardFollowTaskInfos);
            Object message = this.shardFollowTaskInfos.size() > 0 ? "Waiting for [" + this.shardFollowTaskInfos.size() + "] shard follow tasks to be in sync" : "Waiting for following to be unpaused and all shard follow tasks to be up to date";
            builder.field(MESSAGE.getPreferredName(), (String)message);
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    record ShardFollowTaskInfo(String followerIndex, int shardId, long leaderGlobalCheckpoint, long followerGlobalCheckpoint) implements ToXContentObject
    {
        static final ParseField FOLLOWER_INDEX_FIELD = new ParseField("follower_index", new String[0]);
        static final ParseField SHARD_ID_FIELD = new ParseField("shard_id", new String[0]);
        static final ParseField LEADER_GLOBAL_CHECKPOINT_FIELD = new ParseField("leader_global_checkpoint", new String[0]);
        static final ParseField FOLLOWER_GLOBAL_CHECKPOINT_FIELD = new ParseField("follower_global_checkpoint", new String[0]);

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FOLLOWER_INDEX_FIELD.getPreferredName(), this.followerIndex);
            builder.field(SHARD_ID_FIELD.getPreferredName(), this.shardId);
            builder.field(LEADER_GLOBAL_CHECKPOINT_FIELD.getPreferredName(), this.leaderGlobalCheckpoint);
            builder.field(FOLLOWER_GLOBAL_CHECKPOINT_FIELD.getPreferredName(), this.followerGlobalCheckpoint);
            builder.endObject();
            return builder;
        }
    }
}

