/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class UpdateSettingsStep
extends AsyncActionStep {
    public static final String NAME = "update-settings";
    private static final BiFunction<String, LifecycleExecutionState, String> DEFAULT_TARGET_INDEX_NAME_SUPPLIER = (index, state) -> index;
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;
    private final Function<IndexMetadata, Settings> settingsSupplier;

    public UpdateSettingsStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, Settings settings) {
        this(key, nextStepKey, client, DEFAULT_TARGET_INDEX_NAME_SUPPLIER, indexMetadata -> settings);
    }

    public UpdateSettingsStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier, Function<IndexMetadata, Settings> settingsSupplier) {
        super(key, nextStepKey, client);
        this.targetIndexNameSupplier = targetIndexNameSupplier;
        this.settingsSupplier = settingsSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        String indexName = this.targetIndexNameSupplier.apply(indexMetadata.getIndex().getName(), indexMetadata.getLifecycleExecutionState());
        Settings settings = this.settingsSupplier.apply(indexMetadata);
        UpdateSettingsRequest updateSettingsRequest = ((UpdateSettingsRequest)new UpdateSettingsRequest(new String[]{indexName}).masterNodeTimeout(TimeValue.MAX_VALUE)).settings(settings);
        this.getClient(currentState.projectId()).admin().indices().updateSettings(updateSettingsRequest, listener.delegateFailureAndWrap((l, r) -> l.onResponse(null)));
    }

    public Function<IndexMetadata, Settings> getSettingsSupplier() {
        return this.settingsSupplier;
    }
}

