/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.mvdedupe;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.mvdedupe.BatchEncoder;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupe;

public class MultivalueDedupeLong {
    static final int ALWAYS_COPY_MISSING = 300;
    final LongBlock block;
    long[] work = new long[ArrayUtil.oversize((int)2, (int)8)];
    int w;

    public MultivalueDedupeLong(LongBlock block) {
        this.block = block;
    }

    public LongBlock dedupeToBlockAdaptive(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (LongBlock.Builder builder = blockFactory.newLongBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendLong(this.block.getLong(first));
                        continue block9;
                    }
                    default: {
                        if (count < 300) {
                            this.copyMissing(first, count);
                            this.writeUniquedWork(builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.deduplicatedSortedWork(builder);
                    }
                }
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    public LongBlock dedupeToBlockUsingCopyAndSort(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (LongBlock.Builder builder = blockFactory.newLongBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendLong(this.block.getLong(first));
                        continue block9;
                    }
                    default: {
                        this.copyAndSort(first, count);
                        this.deduplicatedSortedWork(builder);
                    }
                }
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    public LongBlock dedupeToBlockUsingCopyMissing(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (LongBlock.Builder builder = blockFactory.newLongBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendLong(this.block.getLong(first));
                        continue block9;
                    }
                    default: {
                        this.copyMissing(first, count);
                        this.writeUniquedWork(builder);
                    }
                }
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    public LongBlock sortToBlock(BlockFactory blockFactory, boolean ascending) {
        try (LongBlock.Builder builder = blockFactory.newLongBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendLong(this.block.getLong(first));
                        continue block9;
                    }
                    default: {
                        this.copyAndSort(first, count);
                        this.writeSortedWork(builder, ascending);
                    }
                }
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    public MultivalueDedupe.HashResult hashAdd(BlockFactory blockFactory, LongHash hash) {
        try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(this.block.getPositionCount());){
            boolean sawNull = false;
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        sawNull = true;
                        builder.appendInt(0);
                        continue block9;
                    }
                    case 1: {
                        long v = this.block.getLong(first);
                        this.hashAdd(builder, hash, v);
                        continue block9;
                    }
                    default: {
                        if (count < 300) {
                            this.copyMissing(first, count);
                            this.hashAddUniquedWork(hash, builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.hashAddSortedWork(hash, builder);
                    }
                }
            }
            MultivalueDedupe.HashResult hashResult = new MultivalueDedupe.HashResult(builder.build(), sawNull);
            return hashResult;
        }
    }

    public IntBlock hashLookup(BlockFactory blockFactory, LongHash hash) {
        try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendInt(0);
                        continue block9;
                    }
                    case 1: {
                        long v = this.block.getLong(first);
                        this.hashLookupSingle(builder, hash, v);
                        continue block9;
                    }
                    default: {
                        if (count < 300) {
                            this.copyMissing(first, count);
                            this.hashLookupUniquedWork(hash, builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.hashLookupSortedWork(hash, builder);
                    }
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    public BatchEncoder batchEncoder(int batchSize) {
        this.block.incRef();
        return new BatchEncoder.Longs(batchSize){

            @Override
            protected void readNextBatch() {
                int position = this.firstPosition();
                if (MultivalueDedupeLong.this.w > 0) {
                    this.ensureCapacity(MultivalueDedupeLong.this.w);
                    this.startPosition();
                    MultivalueDedupeLong.this.encodeUniquedWork(this);
                    this.endPosition();
                    ++position;
                }
                while (position < MultivalueDedupeLong.this.block.getPositionCount()) {
                    int count = MultivalueDedupeLong.this.block.getValueCount(position);
                    int first = MultivalueDedupeLong.this.block.getFirstValueIndex(position);
                    switch (count) {
                        case 0: {
                            this.encodeNull();
                            break;
                        }
                        case 1: {
                            long v = MultivalueDedupeLong.this.block.getLong(first);
                            if (this.hasCapacity(1)) {
                                this.startPosition();
                                this.encode(v);
                                this.endPosition();
                                break;
                            }
                            MultivalueDedupeLong.this.work[0] = v;
                            MultivalueDedupeLong.this.w = 1;
                            return;
                        }
                        default: {
                            if (count < 300) {
                                MultivalueDedupeLong.this.copyMissing(first, count);
                            } else {
                                MultivalueDedupeLong.this.copyAndSort(first, count);
                                MultivalueDedupeLong.this.convertSortedWorkToUnique();
                            }
                            if (this.hasCapacity(MultivalueDedupeLong.this.w)) {
                                this.startPosition();
                                MultivalueDedupeLong.this.encodeUniquedWork(this);
                                this.endPosition();
                                break;
                            }
                            return;
                        }
                    }
                    ++position;
                }
            }

            public void close() {
                MultivalueDedupeLong.this.block.decRef();
            }
        };
    }

    void copyAndSort(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.w = 0;
        for (int i = first; i < end; ++i) {
            this.work[this.w++] = this.block.getLong(i);
        }
        Arrays.sort(this.work, 0, this.w);
    }

    void copyMissing(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.work[0] = this.block.getLong(first);
        this.w = 1;
        block0: for (int i = first + 1; i < end; ++i) {
            long v = this.block.getLong(i);
            for (int j = 0; j < this.w; ++j) {
                if (v == this.work[j]) continue block0;
            }
            this.work[this.w++] = v;
        }
    }

    private void writeUniquedWork(LongBlock.Builder builder) {
        if (this.w == 1) {
            builder.appendLong(this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            builder.appendLong(this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void deduplicatedSortedWork(LongBlock.Builder builder) {
        builder.beginPositionEntry();
        long prev = this.work[0];
        builder.appendLong(prev);
        for (int i = 1; i < this.w; ++i) {
            if (prev == this.work[i]) continue;
            prev = this.work[i];
            builder.appendLong(prev);
        }
        builder.endPositionEntry();
    }

    private void writeSortedWork(LongBlock.Builder builder, boolean ascending) {
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            if (ascending) {
                builder.appendLong(this.work[i]);
                continue;
            }
            builder.appendLong(this.work[this.w - i - 1]);
        }
        builder.endPositionEntry();
    }

    private void hashAddUniquedWork(LongHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hashAdd(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            this.hashAdd(builder, hash, this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void hashAddSortedWork(LongHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hashAdd(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        long prev = this.work[0];
        this.hashAdd(builder, hash, prev);
        for (int i = 1; i < this.w; ++i) {
            if (MultivalueDedupeLong.valuesEqual(prev, this.work[i])) continue;
            prev = this.work[i];
            this.hashAdd(builder, hash, prev);
        }
        builder.endPositionEntry();
    }

    private void hashLookupUniquedWork(LongHash hash, IntBlock.Builder builder) {
        long nextLookup;
        if (this.w == 1) {
            this.hashLookupSingle(builder, hash, this.work[0]);
            return;
        }
        int i = 1;
        long firstLookup = this.hashLookup(hash, this.work[0]);
        while (firstLookup < 0L) {
            if (i >= this.w) {
                builder.appendNull();
                return;
            }
            firstLookup = this.hashLookup(hash, this.work[i]);
            ++i;
        }
        boolean foundSecond = false;
        while (i < this.w) {
            nextLookup = this.hashLookup(hash, this.work[i]);
            if (nextLookup >= 0L) {
                builder.beginPositionEntry();
                this.appendFound(builder, firstLookup);
                this.appendFound(builder, nextLookup);
                ++i;
                foundSecond = true;
                break;
            }
            ++i;
        }
        if (!foundSecond) {
            this.appendFound(builder, firstLookup);
            return;
        }
        while (i < this.w) {
            nextLookup = this.hashLookup(hash, this.work[i]);
            if (nextLookup >= 0L) {
                this.appendFound(builder, nextLookup);
            }
            ++i;
        }
        builder.endPositionEntry();
    }

    private void hashLookupSortedWork(LongHash hash, IntBlock.Builder builder) {
        long nextLookup;
        if (this.w == 1) {
            this.hashLookupSingle(builder, hash, this.work[0]);
            return;
        }
        int i = 1;
        long prev = this.work[0];
        long firstLookup = this.hashLookup(hash, prev);
        while (firstLookup < 0L) {
            if (i >= this.w) {
                builder.appendNull();
                return;
            }
            prev = this.work[i];
            firstLookup = this.hashLookup(hash, prev);
            ++i;
        }
        boolean foundSecond = false;
        while (i < this.w) {
            if (!MultivalueDedupeLong.valuesEqual(prev, this.work[i]) && (nextLookup = this.hashLookup(hash, this.work[i])) >= 0L) {
                prev = this.work[i];
                builder.beginPositionEntry();
                this.appendFound(builder, firstLookup);
                this.appendFound(builder, nextLookup);
                ++i;
                foundSecond = true;
                break;
            }
            ++i;
        }
        if (!foundSecond) {
            this.appendFound(builder, firstLookup);
            return;
        }
        while (i < this.w) {
            if (!MultivalueDedupeLong.valuesEqual(prev, this.work[i]) && (nextLookup = this.hashLookup(hash, this.work[i])) >= 0L) {
                prev = this.work[i];
                this.appendFound(builder, nextLookup);
            }
            ++i;
        }
        builder.endPositionEntry();
    }

    private void encodeUniquedWork(BatchEncoder.Longs encoder) {
        for (int i = 0; i < this.w; ++i) {
            encoder.encode(this.work[i]);
        }
    }

    private void convertSortedWorkToUnique() {
        long prev = this.work[0];
        int end = this.w;
        this.w = 1;
        for (int i = 1; i < end; ++i) {
            if (MultivalueDedupeLong.valuesEqual(prev, this.work[i])) continue;
            prev = this.work[i];
            this.work[this.w++] = prev;
        }
    }

    private void grow(int size) {
        this.work = ArrayUtil.grow((long[])this.work, (int)size);
    }

    private void hashAdd(IntBlock.Builder builder, LongHash hash, long v) {
        this.appendFound(builder, hash.add(v));
    }

    private long hashLookup(LongHash hash, long v) {
        return hash.find(v);
    }

    private void hashLookupSingle(IntBlock.Builder builder, LongHash hash, long v) {
        long found = this.hashLookup(hash, v);
        if (found >= 0L) {
            this.appendFound(builder, found);
        } else {
            builder.appendNull();
        }
    }

    private void appendFound(IntBlock.Builder builder, long found) {
        builder.appendInt(Math.toIntExact(BlockHash.hashOrdToGroupNullReserved(found)));
    }

    private static boolean valuesEqual(long lhs, long rhs) {
        return lhs == rhs;
    }
}

