/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.AggregateMetricDoubleArrayBlock;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.CompositeBlock;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;

public final class ElementType
extends Enum<ElementType> {
    public static final /* enum */ ElementType BOOLEAN = new ElementType(0, "Boolean", BlockFactory::newBooleanBlockBuilder, BooleanBlock::readFrom);
    public static final /* enum */ ElementType INT = new ElementType(1, "Int", BlockFactory::newIntBlockBuilder, IntBlock::readFrom);
    public static final /* enum */ ElementType LONG = new ElementType(2, "Long", BlockFactory::newLongBlockBuilder, LongBlock::readFrom);
    public static final /* enum */ ElementType FLOAT = new ElementType(3, "Float", BlockFactory::newFloatBlockBuilder, FloatBlock::readFrom);
    public static final /* enum */ ElementType DOUBLE = new ElementType(4, "Double", BlockFactory::newDoubleBlockBuilder, DoubleBlock::readFrom);
    public static final /* enum */ ElementType NULL = new ElementType(5, "Null", (blockFactory, estimatedSize) -> new ConstantNullBlock.Builder(blockFactory), BlockStreamInput::readConstantNullBlock);
    public static final /* enum */ ElementType BYTES_REF = new ElementType(6, "BytesRef", BlockFactory::newBytesRefBlockBuilder, BytesRefBlock::readFrom);
    public static final /* enum */ ElementType DOC = new ElementType(7, "Doc", DocBlock::newBlockBuilder, in -> {
        throw new UnsupportedOperationException("can't read doc blocks");
    });
    public static final /* enum */ ElementType COMPOSITE = new ElementType(8, "Composite", (blockFactory, estimatedSize) -> {
        throw new UnsupportedOperationException("can't build composite blocks");
    }, CompositeBlock::readFrom);
    public static final /* enum */ ElementType UNKNOWN = new ElementType(9, "Unknown", (blockFactory, estimatedSize) -> {
        throw new UnsupportedOperationException("can't build null blocks");
    }, in -> {
        throw new UnsupportedOperationException("can't read unknown blocks");
    });
    public static final /* enum */ ElementType AGGREGATE_METRIC_DOUBLE = new ElementType(10, "AggregateMetricDouble", BlockFactory::newAggregateMetricDoubleBlockBuilder, AggregateMetricDoubleArrayBlock::readFrom);
    private static final TransportVersion ESQL_SERIALIZE_BLOCK_TYPE_CODE;
    private final String pascalCaseName;
    private final BuilderSupplier builder;
    private final byte writableCode;
    private final String legacyWritableName;
    final BlockReader reader;
    private static final Map<String, ElementType> fromLegacyNames;
    private static final /* synthetic */ ElementType[] $VALUES;

    public static ElementType[] values() {
        return (ElementType[])$VALUES.clone();
    }

    public static ElementType valueOf(String name) {
        return Enum.valueOf(ElementType.class, name);
    }

    private ElementType(int writeableCode, String pascalCaseName, BuilderSupplier builder, BlockReader reader) {
        this.writableCode = (byte)writeableCode;
        if (this.writableCode != writeableCode) {
            throw new IllegalArgumentException("code must be in the range [0, 127); got " + writeableCode);
        }
        this.pascalCaseName = pascalCaseName;
        this.legacyWritableName = "Null".equals(pascalCaseName) ? "ConstantNullBlock" : pascalCaseName + "Block";
        this.builder = builder;
        this.reader = reader;
    }

    public Block.Builder newBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        return this.builder.newBlockBuilder(blockFactory, estimatedSize);
    }

    public static ElementType fromJava(Class<?> type) {
        ElementType elementType;
        if (type == Integer.class) {
            elementType = INT;
        } else if (type == Long.class) {
            elementType = LONG;
        } else if (type == Float.class) {
            elementType = FLOAT;
        } else if (type == Double.class) {
            elementType = DOUBLE;
        } else if (type == String.class || type == BytesRef.class) {
            elementType = BYTES_REF;
        } else if (type == Boolean.class) {
            elementType = BOOLEAN;
        } else if (type == AggregateMetricDoubleBlockBuilder.AggregateMetricDoubleLiteral.class) {
            elementType = AGGREGATE_METRIC_DOUBLE;
        } else if (type == null || type == Void.class) {
            elementType = NULL;
        } else {
            throw new IllegalArgumentException("Unrecognized class type " + String.valueOf(type));
        }
        return elementType;
    }

    public String pascalCaseName() {
        return this.pascalCaseName;
    }

    static ElementType readFrom(StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(ESQL_SERIALIZE_BLOCK_TYPE_CODE)) {
            byte b = in.readByte();
            return ElementType.values()[b];
        }
        String writeableName = in.readString();
        ElementType elementType = fromLegacyNames.get(writeableName);
        if (elementType == null) {
            throw new IllegalArgumentException("Unknown element type for named writable [" + writeableName + "]");
        }
        return elementType;
    }

    void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_SERIALIZE_BLOCK_TYPE_CODE)) {
            out.writeByte(this.writableCode);
        } else {
            out.writeString(this.legacyWritableName);
        }
    }

    private static /* synthetic */ ElementType[] $values() {
        return new ElementType[]{BOOLEAN, INT, LONG, FLOAT, DOUBLE, NULL, BYTES_REF, DOC, COMPOSITE, UNKNOWN, AGGREGATE_METRIC_DOUBLE};
    }

    static {
        $VALUES = ElementType.$values();
        ESQL_SERIALIZE_BLOCK_TYPE_CODE = TransportVersion.fromName((String)"esql_serialize_block_type_code");
        ElementType[] values = ElementType.values();
        for (int i = 0; i < values.length; ++i) {
            assert (values[i].writableCode == i);
        }
        fromLegacyNames = Arrays.stream(values).collect(Collectors.toUnmodifiableMap(e -> e.legacyWritableName, Function.identity()));
    }

    private static interface BuilderSupplier {
        public Block.Builder newBlockBuilder(BlockFactory var1, int var2);
    }

    static interface BlockReader {
        public Block readBlock(BlockStreamInput var1) throws IOException;
    }
}

