/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatLookup;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.FloatVectorBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class ConstantFloatVector
extends AbstractVector
implements FloatVector {
    static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantFloatVector.class);
    private final float value;

    ConstantFloatVector(float value, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.value = value;
    }

    @Override
    public float getFloat(int position) {
        return this.value;
    }

    @Override
    public FloatBlock asBlock() {
        return new FloatVectorBlock(this);
    }

    @Override
    public FloatVector filter(int ... positions) {
        return this.blockFactory().newConstantFloatVector(this.value, positions.length);
    }

    @Override
    public FloatBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return new FloatVectorBlock(this);
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return new FloatVectorBlock(this);
            }
            return (FloatBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (FloatBlock.Builder builder = this.blockFactory().newFloatBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (mask.getBoolean(p)) {
                    builder.appendFloat(this.value);
                    continue;
                }
                builder.appendNull();
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    public ReleasableIterator<FloatBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        if (positions.getPositionCount() == 0) {
            return ReleasableIterator.empty();
        }
        IntVector positionsVector = positions.asVector();
        if (positionsVector == null) {
            return new FloatLookup(this.asBlock(), positions, targetBlockSize);
        }
        int min = positionsVector.min();
        if (min < 0) {
            throw new IllegalArgumentException("invalid position [" + min + "]");
        }
        if (min > this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)((FloatBlock)positions.blockFactory().newConstantNullBlock(positions.getPositionCount())));
        }
        if (positionsVector.max() < this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)positions.blockFactory().newConstantFloatBlockWith(this.value, positions.getPositionCount()));
        }
        return new FloatLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public ElementType elementType() {
        return ElementType.FLOAT;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public FloatVector deepCopy(BlockFactory blockFactory) {
        return blockFactory.newConstantFloatVector(this.value, this.getPositionCount());
    }

    public long ramBytesUsed() {
        return RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FloatVector) {
            FloatVector that = (FloatVector)obj;
            return FloatVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return FloatVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", value=" + this.value + "]";
    }
}

