/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanLookup;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BooleanVectorBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class ConstantBooleanVector
extends AbstractVector
implements BooleanVector {
    static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantBooleanVector.class);
    private final boolean value;

    ConstantBooleanVector(boolean value, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.value = value;
    }

    @Override
    public boolean getBoolean(int position) {
        return this.value;
    }

    @Override
    public BooleanBlock asBlock() {
        return new BooleanVectorBlock(this);
    }

    @Override
    public BooleanVector filter(int ... positions) {
        return this.blockFactory().newConstantBooleanVector(this.value, positions.length);
    }

    @Override
    public BooleanBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return new BooleanVectorBlock(this);
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return new BooleanVectorBlock(this);
            }
            return (BooleanBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (BooleanBlock.Builder builder = this.blockFactory().newBooleanBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (mask.getBoolean(p)) {
                    builder.appendBoolean(this.value);
                    continue;
                }
                builder.appendNull();
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    public ReleasableIterator<BooleanBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        if (positions.getPositionCount() == 0) {
            return ReleasableIterator.empty();
        }
        IntVector positionsVector = positions.asVector();
        if (positionsVector == null) {
            return new BooleanLookup(this.asBlock(), positions, targetBlockSize);
        }
        int min = positionsVector.min();
        if (min < 0) {
            throw new IllegalArgumentException("invalid position [" + min + "]");
        }
        if (min > this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)((BooleanBlock)positions.blockFactory().newConstantNullBlock(positions.getPositionCount())));
        }
        if (positionsVector.max() < this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)positions.blockFactory().newConstantBooleanBlockWith(this.value, positions.getPositionCount()));
        }
        return new BooleanLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public boolean allTrue() {
        return this.value;
    }

    @Override
    public boolean allFalse() {
        return !this.value;
    }

    @Override
    public ElementType elementType() {
        return ElementType.BOOLEAN;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public BooleanVector deepCopy(BlockFactory blockFactory) {
        return blockFactory.newConstantBooleanVector(this.value, this.getPositionCount());
    }

    public long ramBytesUsed() {
        return RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BooleanVector) {
            BooleanVector that = (BooleanVector)obj;
            return BooleanVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BooleanVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", value=" + this.value + "]";
    }
}

