/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.PresentGroupingAggregatorFunction;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public class PresentAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("present", ElementType.BOOLEAN));
    private final List<Integer> channels;
    private boolean state;

    public static AggregatorFunctionSupplier supplier() {
        return new AggregatorFunctionSupplier(){

            @Override
            public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
                return PresentAggregatorFunction.intermediateStateDesc();
            }

            @Override
            public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
                return PresentGroupingAggregatorFunction.intermediateStateDesc();
            }

            @Override
            public AggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
                return PresentAggregatorFunction.create(channels);
            }

            @Override
            public GroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
                return PresentGroupingAggregatorFunction.create(driverContext, channels);
            }

            @Override
            public String describe() {
                return "present";
            }
        };
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    public static PresentAggregatorFunction create(List<Integer> inputChannels) {
        return new PresentAggregatorFunction(inputChannels, false);
    }

    private PresentAggregatorFunction(List<Integer> channels, boolean state) {
        this.channels = channels;
        this.state = state;
    }

    @Override
    public int intermediateBlockCount() {
        return PresentAggregatorFunction.intermediateStateDesc().size();
    }

    private int blockIndex() {
        return this.channels.get(0);
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (mask.isConstant() && !mask.getBoolean(0)) {
            return;
        }
        Object block = page.getBlock(this.blockIndex());
        this.state = mask.isConstant() ? block.getTotalValueCount() > 0 : this.presentMasked((Block)block, mask);
    }

    private boolean presentMasked(Block block, BooleanVector mask) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (!mask.getBoolean(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        int blockIndex = this.blockIndex();
        assert (page.getBlockCount() >= blockIndex + PresentAggregatorFunction.intermediateStateDesc().size());
        Object uncastBlock = page.getBlock(this.channels.get(0));
        if (uncastBlock.areAllValuesNull()) {
            return;
        }
        BooleanVector present = ((BooleanBlock)page.getBlock(this.channels.get(0))).asVector();
        assert (present.getPositionCount() == 1);
        if (present.getBoolean(0)) {
            this.state = true;
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.evaluateFinal(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = driverContext.blockFactory().newConstantBooleanBlockWith(this.state, 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
    }
}

