/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.PercentileIntAggregatorFunction;
import org.elasticsearch.compute.aggregation.PercentileIntGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileIntAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final double percentile;

    public PercentileIntAggregatorFunctionSupplier(double percentile) {
        this.percentile = percentile;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return PercentileIntAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return PercentileIntGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public PercentileIntAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return PercentileIntAggregatorFunction.create(driverContext, channels, this.percentile);
    }

    @Override
    public PercentileIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return PercentileIntGroupingAggregatorFunction.create(channels, driverContext, this.percentile);
    }

    @Override
    public String describe() {
        return "percentile of ints";
    }
}

