/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import com.carrotsearch.hppc.BitMixer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;

final class HllStates {
    private HllStates() {
    }

    static BytesRef serializeHLL(int groupId, HyperLogLogPlusPlus hll) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamStreamOutput out = new OutputStreamStreamOutput((OutputStream)baos);
        try {
            hll.writeTo((long)groupId, (StreamOutput)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new BytesRef(baos.toByteArray());
    }

    static AbstractHyperLogLogPlusPlus deserializeHLL(BytesRef bytesRef) {
        ByteArrayStreamInput in = new ByteArrayStreamInput(bytesRef.bytes);
        in.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        try {
            return HyperLogLogPlusPlus.readFrom((StreamInput)in, (BigArrays)BigArrays.NON_RECYCLING_INSTANCE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static int copyToArray(BytesReference bytesReference, byte[] arr, int offset) {
        int origOffset = offset;
        BytesRefIterator iterator = bytesReference.iterator();
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                System.arraycopy(slice.bytes, slice.offset, arr, offset, slice.length);
                offset += slice.length;
            }
            return offset - origOffset;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class GroupingState
    implements GroupingAggregatorState {
        private final MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        final HyperLogLogPlusPlus hll;

        GroupingState(BigArrays bigArrays, int precision) {
            this.hll = new HyperLogLogPlusPlus(HyperLogLogPlusPlus.precisionFromThreshold((long)precision), bigArrays, 1L);
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        }

        void collect(int groupId, long v) {
            this.doCollect(groupId, BitMixer.mix64((long)v));
        }

        void collect(int groupId, int v) {
            this.doCollect(groupId, BitMixer.mix64((long)v));
        }

        void collect(int groupId, double v) {
            this.doCollect(groupId, BitMixer.mix64((long)Double.doubleToLongBits(v)));
        }

        void collect(int groupId, BytesRef bytes) {
            MurmurHash3.hash128((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)this.hash);
            this.collect(groupId, this.hash.h1);
        }

        private void doCollect(int groupId, long hash) {
            this.hll.collect((long)groupId, hash);
        }

        long cardinality(int groupId) {
            return this.hll.cardinality((long)groupId);
        }

        void merge(int groupId, BytesRef other, int otherGroup) {
            this.hll.merge((long)groupId, HllStates.deserializeHLL(other), (long)otherGroup);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 1);
            try (BytesRefBlock.Builder builder = driverContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int group = selected.getInt(i);
                    builder.appendBytesRef(HllStates.serializeHLL(group, this.hll));
                }
                blocks[offset] = builder.build();
            }
        }

        public void close() {
            Releasables.close((Releasable)this.hll);
        }
    }

    static class SingleState
    implements AggregatorState {
        private static final int SINGLE_BUCKET_ORD = 0;
        final HyperLogLogPlusPlus hll;
        private final MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();

        SingleState(BigArrays bigArrays, int precision) {
            this.hll = new HyperLogLogPlusPlus(HyperLogLogPlusPlus.precisionFromThreshold((long)precision), bigArrays, 1L);
        }

        void collect(long v) {
            this.doCollect(BitMixer.mix64((long)v));
        }

        void collect(int v) {
            this.doCollect(BitMixer.mix64((long)v));
        }

        void collect(double v) {
            this.doCollect(BitMixer.mix64((long)Double.doubleToLongBits(v)));
        }

        void collect(BytesRef bytes) {
            MurmurHash3.hash128((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)this.hash);
            this.collect(this.hash.h1);
        }

        private void doCollect(long hash) {
            this.hll.collect(0L, hash);
        }

        long cardinality() {
            return this.hll.cardinality(0L);
        }

        void merge(int groupId, AbstractHyperLogLogPlusPlus other, int otherGroup) {
            this.hll.merge((long)groupId, other, (long)otherGroup);
        }

        void merge(int groupId, BytesRef other, int otherGroup) {
            this.hll.merge((long)groupId, HllStates.deserializeHLL(other), (long)otherGroup);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            assert (blocks.length >= offset + 1);
            blocks[offset] = driverContext.blockFactory().newConstantBytesRefBlockWith(HllStates.serializeHLL(0, this.hll), 1);
        }

        public void close() {
            Releasables.close((Releasable)this.hll);
        }
    }
}

