/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.Closeable;
import java.io.IOException;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.test.TestCluster;

public record CloseableTestClusterWrapper(TestCluster testCluster) implements Closeable
{
    @Override
    public void close() throws IOException {
        this.testCluster().close();
    }

    public static Iterable<Closeable> wrap(Iterable<? extends TestCluster> clusters) {
        return () -> Iterators.map(clusters.iterator(), CloseableTestClusterWrapper::new);
    }

    public static Iterable<Closeable> wrap(TestCluster ... clusters) {
        return CloseableTestClusterWrapper.wrap(() -> Iterators.forArray((Object[])clusters));
    }
}

